/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import com.sonicsw.mx.config.IConfigPath;

public class DSToViewPathStringTableColumn extends ConfigBeanTableColumn
{
    protected IConfigPath m_configPath;

    public DSToViewPathStringTableColumn(int         modelIndex,
                                         IConfigPath path,
                                         String      title,
                                         int         width)
    {
        super(modelIndex, path, title, width);
    }

    @Override
    public Object getColumnValue(Object rowModel)
    {
        String value  = "";
        Object object = super.getColumnValue(rowModel);

        if (object instanceof String)
        {
            value = formatPath((String)object);
        }

        return value;
    }

    public static String formatPath(String logicalPath)
    {
        int splitPos = logicalPath.lastIndexOf("/");
        StringBuffer sb = new StringBuffer(logicalPath.substring(splitPos + 1));

        if (splitPos >= 0)
        {
            String temp = logicalPath.substring(0, splitPos);

            if (temp.trim().length() == 0)
            {
                temp = "/";
            }

            sb.append(" ( ").append(temp).append(" )");
        }

        return sb.toString();
    }
}
