package com.sonicsw.ma.gui.table;

import java.util.List;

import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public interface IModelTableModel
    extends TableModel
{
    /**
     * Return the contents of the model as a java.util.List.
     */
    public List getContents();

    /**
     * Assign the model List contents of this ModelListTableModel.
     */
    public void setContents(List contents);

    /**
     * Return this ModelListTableModel's array of TableColumnAdapters.
     */
    public TableColumn[] getColumns();

    /**
     * Return the TableColumnAdapter for the specified model column index.
     */
    public TableColumn getColumn(int modelColumnIndex);

    /**
     * Return the row model object at the specified index of this
     * ModelListTableModel.
     */
    public Object getRowModel(int row);

    public int findCell(int startRow, int columnIndex, Object value);

    /**
     * Return the index of the specified object in the contents List if it
     * is present, or the index at which to insert the object otherwise,
     * encoded as (-1 - insertionIndex).
     * If the contents are sorted, a binary search is used.  Otherwise a
     * linear search is used and if the object is not present the insertion
     * index is at the end of the list.
     */
    public int getIndexOf(Object obj);

    /**
     * Insert the specified row model object into this ModelListTableModel
     * at the specified row index.
     */
    public void insertRow(Object rowModel, int index);

    /**
     * Insert the specified row model object into this ModelListTableModel
     * maintaining sorted order if the model is currently sorted, or at the
     * end otherwise.  It is illegal to insert a row model object that is
     * already present.
     *
     * @deprecated  As of 2.1.1 release should use addRow instead.
     */
    public void insertRowMaintainSort(Object rowModel);

    /**
     * Adds a new row model object into the table model.
     *
     * @param rowModel  The new row model object.
     * @return          The index (location) where the row was inserted/added.
     */
    public int addRow(Object rowModel);

    /**
     * Delete the row at the specified index.
     */
    public void deleteRow(int index);

    /**
     * Delete the specified object from this ModelListTableModel if it is present.
     */
    public void delete(Object obj);

    /**
     * Clear the contents of the model.
     */
    public void clear();

    /**
     * Notify TableModelListeners that the specified row has changed.
     */
    public void rowChanged(int index);

    //-------------------------------------------------------------------------
    //
    // Sorting Support
    //
    //-------------------------------------------------------------------------

    public void activateSort(boolean bSortIsActive);
    public boolean isSortActivated();

    /**
     * Sort this ModelListTableModel by the specified model column.  If the
     * table is not currently sorted by that column, the column's normal
     * Comparator is used to perform the sort.  Otherwise, the column's
     * reverse comparator is used.
     */
    public void sortByColumn(int modelColumnIndex);

    /**
     * Sort this ModelListTableModel by the specified model column, specifying
     * whether to sort in ascending or descending order.
     *
     * The ModelListTableModel is sorted by extracting the complete contents
     * List into an object array, sorting the array using the Comparator,
     * and then replacing the contents of the list with the sorted array.
     */
    public void sortByColumn(int modelColumnIndex, boolean ascending);

    /**
     * Assert that the table is sorted by the specified column's Comparator,
     * and indicate whether it's sorted ascending or not.  If the sortColumn
     * and/or sortComparator are changed by this method, PropertyChangeEvents
     * are fired to notify listeners about the changes.
     */
    public void setSortedByColumn(int modelColumnIndex, boolean ascending);

    /**
     * Return whether this ModelListTableModel is current sorted.
     */
    public boolean isSorted();

    /**
     * Return the model column by which the table is sorted, or -1 if it's
     * not currently sorted.
     */
    public int getSortColumn();

    /**
     * Return whether this ModelListTableModel is sorted in ascending order.
     * The results of this method are meaningless if it is not sorted at all.
     */
    public boolean isSortedInAscendingOrder();
}