package com.sonicsw.ma.gui.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;

import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IPlugin;

public class MessageContentPane extends JLabel implements IContentPane
{
    private IPlugin m_plugin;
    private String  m_message;


    public MessageContentPane(IPlugin plugin, String message)
    {
        m_plugin  = plugin;
        m_message = message;

        initUI();
    }

    @Override
    public IPlugin getPlugin()
    {
        return m_plugin;
    }

    @Override
    public Object getSelectedItem()
    {
        return null;
    }

    @Override
    public Object[] getSelectedItems()
    {
        return new Object[0];
    }

    public int[] getSelectedIndices()
    {
        return new int[0];
    }

    public Object getSelected(int index)
    {
        return null;
    }

    public int getSelectedCount()
    {
        return 0;
    }

    @Override
    public void refresh()
    {
    }

    public void insert(Object object)
    {
    }

    public void remove(Object object)
    {
    }

    @Override
    public JComponent getComponent()
    {
        return this;
    }

    @Override
    public AbstractButton[] getToolbarItems()
    {
        return null;
    }

    @Override
    public JComponent[] getMenuItems(int type)
    {
        return null;
    }

    @Override
    public BasicAction getDefaultAction()
    {
        return null;
    }

    protected final void initUI()
    {
        setLayout(new BorderLayout());

        setOpaque(true);
        setBackground(Color.white);
        setHorizontalAlignment(JLabel.CENTER);
        setVerticalTextPosition(JLabel.BOTTOM);
        setHorizontalTextPosition(JLabel.CENTER);
        setFont(getFont().deriveFont(Font.BOLD));
        setIcon(ResourceManager.getApplicationLogo(getClass(), "logo"));
        setText(m_message);
    }

}
