/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import javax.swing.table.TableCellRenderer;

import com.sonicsw.ma.gui.dev.DevElementPlugin;
import com.sonicsw.ma.gui.dev.DevModel;
import com.sonicsw.ma.gui.file.FileElementModel;
import com.sonicsw.ma.gui.file.FileElementPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.PluginAttributes;

public class ObjectColumn extends RowTableColumn {

    public static final String NAME_STR = "Name";
    public static final String SIZE_STR = "Size";
    public static final String TYPE_STR = "Type";
    public static final String DATEMODIFIED_STR = "Date Modified";
    public static final String DATECREATED_STR = "Date Created";
    public static final String ATTRIBUTES_STR = "Attributes";
    public static final String VERSION_STR = "Version";

    public ObjectColumn(int modelIndex, String name, int initialWidth) {
        this(modelIndex, name, initialWidth, null);
    }

    public ObjectColumn(int modelIndex, String name, int initialWidth, TableCellRenderer renderer) {
        super(modelIndex, name, initialWidth);

// v5.0 AHJ - the BasicComparator is a hack to solve the problem where IState
//            objects don't implement Comparable and have no "useful" toString
//            implementation!
//
//        setColumnComparator(BasicComparator.getInstance());

        if (renderer != null)
        {
            setColumnCellRenderer(renderer);
        }
    }

    private void setColumnCellRenderer(TableCellRenderer renderer) {
        setCellRenderer(renderer);
    }
    
    @Override
    public Object getColumnValue(Object rowModel) {
        if (rowModel instanceof IPlugin) {
            IPlugin plugin = (IPlugin) rowModel;
            if (NAME_STR.equalsIgnoreCase((String) getHeaderValue())) {
                return plugin.toString();
            } else if (SIZE_STR.equalsIgnoreCase((String) getHeaderValue())) {
                if (plugin instanceof FileElementPlugin) {
                    FileElementModel model = (FileElementModel) plugin.getModel();
                    return model.getSize();
                } else if (plugin instanceof DevElementPlugin) {
                    DevModel model = (DevModel) plugin.getModel();
                    return model.getSize();
                } else {
                    //
                    return new Long(-1);
                }
            } else if (TYPE_STR.equalsIgnoreCase((String) getHeaderValue())) {
                if (plugin instanceof DevElementPlugin)
                {
                    return (((DevModel) plugin.getModel()).getType());
                }
                else if (plugin instanceof FileElementPlugin)
                {
                    return (((FileElementModel) plugin.getModel()).getType());
                }
                else
                {
                    return (plugin.getAttributes().getDisplayType());
                }
            } else if (DATEMODIFIED_STR.equalsIgnoreCase((String) getHeaderValue())) {
                if (plugin instanceof FileElementPlugin) {
                    FileElementModel model = (FileElementModel) plugin.getModel();
                    return (model.getLastModifiedTime());
                } else if (plugin instanceof DevElementPlugin) {
                    DevModel model = (DevModel) plugin.getModel();
                    return (model.getLastModifiedTime());
                }
                else
                {
                    return ("");
                }
            } else if (DATECREATED_STR.equalsIgnoreCase((String) getHeaderValue())) {
                if (plugin instanceof FileElementPlugin) {
                    FileElementModel model = (FileElementModel) plugin.getModel();
                    return (model.getCreationTime());
                } else if (plugin instanceof DevElementPlugin) {
                    DevModel model = (DevModel) plugin.getModel();

                    return (model.getCreationTime());
                }
                else
                {
                    return ("");
                }
            } else if (ATTRIBUTES_STR.equalsIgnoreCase((String) getHeaderValue())) {
                StringBuffer sb = new StringBuffer();
                if (plugin.getAttributes().isSystem())
                {
                    sb.append("S");
                }
//        if (plugin.getAttributes().isReadOnly())
//            sb.append("R");
//        if (plugin.getAttributes().isHidden())
//            sb.append("H");
                return (sb.toString());
            } else if (VERSION_STR.equalsIgnoreCase((String) getHeaderValue())) {
                PluginAttributes attributes = ((IPlugin) rowModel).getAttributes();
                return (attributes.getProductVersion());
            }

            return plugin;
        }else if (rowModel instanceof String){
            return rowModel;
        }
        return null;
    }
}
