/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import java.util.Iterator;
import java.util.List;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.IFilterable;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.plugin.IPlugin;

public abstract class ObjectListContentPane extends AbstractTableContentPane
{
    public ObjectListContentPane(IPlugin plugin)
    {
        super(plugin);
    }

    @Override
    public void setTableData(final IPlugin plugin)
    {
		JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());

		try
		{
			final IModelTableModel tableModel = (IModelTableModel)m_table.getModel();
			tableModel.clear();

			// Get the top level AttributeMap that will be used to create the
			// NamedAttributeMap row model
			final List rowModel = getRowModel(plugin);

			if (rowModel != null)
			{
                boolean isSortActivated = tableModel.isSortActivated();

                if(isSortActivated)
                {
                    tableModel.activateSort(false);
                }
                
                for(Iterator i = rowModel.iterator(); i.hasNext(); )
				{
                    Object obj = i.next();

                    if(isFilterActivated() ? obj instanceof IFilterable && ((IFilterable)obj).canDisplay(tableModel) : true){
                        tableModel.addRow(obj);
                    }
                }
                
                if(isSortActivated)
                {
                    tableModel.activateSort(true);
                    tableModel.sortByColumn(tableModel.getSortColumn(), tableModel.isSortedInAscendingOrder());
				}
			}
		}
		finally
		{
			wc.release();
		}
    }

    protected abstract List getRowModel(IPlugin plugin);
}
