/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import java.awt.Component;
import java.beans.PropertyDescriptor;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import com.sonicsw.ma.gui.util.ExtendedJTable;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IPlugin;

/**
 * This column adapter is used to display apsects IConfigPlugin's
 */
public class PluginColumn extends BeanPropertyTableColumn
{
    public PluginColumn(int modelIndex, PropertyDescriptor propDesc, int width)
    {
        super(modelIndex, propDesc, width);

        // Only set table cell renderer for the "name" aspect value, otherwise we'll
        // get an icon displayed for every column in the table.
        if (propDesc.getName().equals("name"))
        {
            setColumnCellRenderer(new PluginTableCellRenderer());
        }
    }

    private void setColumnCellRenderer(PluginTableCellRenderer renderer) {
        setCellRenderer(renderer);
    }

    class PluginTableCellRenderer extends ExtendedJTable.ExtendedTableCellRenderer
    {
        @Override
        public Component getTableCellRendererComponent(JTable  table,
                                                       Object  value,
                                                       boolean isSelected,
                                                       boolean hasFocus,
                                                       int     row,
                                                       int     column)
        {
            Component res = super.getTableCellRendererComponent(table, value,
                                          isSelected, hasFocus, row, column);
            Icon icon = null;

            // Set the icon for the column.
            if (table instanceof JRowTable)
            {
                Object rowModel = ((IModelTableModel)table.getModel()).getRowModel(row);

                if (rowModel instanceof IPlugin)
                {
                    IPlugin plugin = (IPlugin)rowModel;

                    icon = ResourceManager.getTypeIcon(plugin.getClass(), plugin.getAttributes().getType());
                }
            }

            if (icon != null)
            {
                ((JLabel)res).setIcon(icon);
            }

            return this;
        }
    }

}
