/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.table.TableColumn;

import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginChangeListener;
import com.sonicsw.ma.plugin.PluginDnd;

public class PluginContentPane extends ObjectListContentPane
    implements IPluginChangeListener
{
    public PluginContentPane(IPlugin plugin)
    {
        super(plugin);

        new PluginDnd(getTable());
    }

    /**
     * This returns the menu items of the selected child plugin in the table
     */
    @Override
    public JComponent[] getMenuItems(int type)
    {
        if (getTable().getSelectedRowCount() == 1)
        {
            IModelTableModel tableModel = (IModelTableModel)getTable().getModel();

            int nSelectedRow = getTable().getSelectedRow();

            if (nSelectedRow != -1)
            {
                Object rowModel = tableModel.getRowModel(nSelectedRow);

                if (rowModel != null)
                {
                    JComponent[] items = ((IPlugin)rowModel).getMenuItems(type);

                    if (items != null)
                    {
                        ArrayList list = new ArrayList();

                        for (int i = 0; i < items.length; i++)
                        {
                            if (items[i] instanceof JMenuItem)
                            {
                                list.add(items[i]);
                            }
                        }
                        return (JComponent[])list.toArray(new JComponent[list.size()]);
                    }
                }
            }
        }

        return null;
    }

    @Override
    protected List getRowModel(IPlugin plugin)
    {
        ArrayList list = new ArrayList();

        for (int i = 0; i < ((AbstractGUIPlugin)plugin).getChildCount(); i++)
        {
            if (((AbstractGUIPlugin)plugin).getChildAt(i)instanceof IPlugin)
            {
                list.add(((AbstractGUIPlugin)plugin).getChildAt(i));
            }
        }
        return list;
    }

    @Override
    public TableColumn[] getColumns()
    {
        return new TableColumn[]
        {
            new ObjectColumn(0, "Name",    40, new PluginNameTableCellRenderer()),
            new ObjectColumn(1, "Type",    40, new PluginTypeTableCellRenderer()),
            new ObjectColumn(2, "Version", 20, new PluginVersionTableCellRenderer()),
        };
    }

    @Override
    public void onAdded(IPlugin plugin)
    {
        addRowModel(plugin);
    }

    @Override
    public void onUpdated(IPlugin plugin)
    {
        refreshRowModel(plugin);
    }

    @Override
    public void onDeleted(IPlugin plugin)
    {
        IModelTableModel model = (IModelTableModel)m_table.getModel();

        int     index    = model.getIndexOf(plugin);
        boolean selected = m_table.isRowSelected(index);

        removeRowModel(plugin);

        if(selected && index > 0)
        {
            index--;
            m_table.setRowSelectionInterval(index, index);
        }

        if (selected && m_table.getRowCount() == 0)
        {
            m_table.clearSelection();
        }
    }

    @Override
    public void onRenamed(IPlugin plugin)
    {
        refreshRowModel(plugin);
    }
}
