/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;

import com.sonicsw.ma.gui.dev.AbstractDevPlugin;
import com.sonicsw.ma.gui.dev.DevModel;
import com.sonicsw.ma.gui.util.ColorIcon;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.ExtendedJTable;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.gui.util.StateHelper;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.PluginAttributes;

public class PluginNameTableCellRenderer extends ExtendedJTable.ExtendedTableCellRenderer
{
    @Override
    public Component getTableCellRendererComponent(JTable table,
                                                   Object value,
                                                   boolean isSelected,
                                                   boolean hasFocus,
                                                   int row,
                                                   int column)
    {
        JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

        // Set the icon for the column.
        if (table.getModel() instanceof ModelListTableModel)
        {
            Object rowModel = ((ModelListTableModel)table.getModel()).getRowModel(row);

            if (rowModel instanceof IPlugin)
            {
                IPlugin          plugin     = (IPlugin)rowModel;
                PluginAttributes attributes = plugin.getAttributes();
                String           pluginType = attributes.getType();
                Icon             icon       = null;

                if (plugin instanceof AbstractDevPlugin)
                {
                    icon = ((DevModel)plugin.getModel()).getTypeIcon();
                }
                else
                if (pluginType != null)
                {
                    icon = ResourceManager.getTypeIcon(plugin.getClass(), pluginType);
                }
                else
                {
                    icon = UIManager.getIcon("Tree.closedIcon");
                }

                if (attributes.isRuntimeRoot() || attributes.isStateable())
                {
                    Color backgroundColor = Color.blue;

                    if (attributes.getState() != null)
                    {
                        backgroundColor = StateHelper.componentStateToColor(attributes.getState());
                    }

                    icon = new ExtendedImageIcon(new ColorIcon(backgroundColor), icon);
                }

                result.setIcon(icon);

                if (plugin instanceof IConfigPlugin)
                {
                    result.setFont(((IConfigPlugin)plugin).isTemplatePrototype() ?  getItalicFont() : getPlainFont());
                }
            }
        }
        return result;
    }
    
    //------------------------------------------------------------------------
    //
    // Lazy loaders for fonts...no point creating unnecessary resources until
    // they are needed
    //
    //------------------------------------------------------------------------
    
    protected Font m_plainFont = null;
    protected Font m_italicFont = null;

    private Font getPlainFont()
    {
        if (m_plainFont == null)
        {
            m_plainFont = getFont().deriveFont(Font.PLAIN);
        }

        return m_plainFont;
    }
    
    private Font getItalicFont()
    {
        if (m_italicFont == null)
        {
            m_italicFont = getFont().deriveFont(Font.ITALIC | Font.BOLD);
        }
        
        return m_italicFont;
    }
}
