/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;

import com.sonicsw.ma.gui.util.ExtendedJTable;

public class PluginSizeTableCellRenderer extends ExtendedJTable.ExtendedTableCellRenderer
{
    public PluginSizeTableCellRenderer()
    {
        super(RIGHT);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table,
                                                   Object value,
                                                   boolean isSelected,
                                                   boolean hasFocus,
                                                   int row,
                                                   int column)
    {                                                       
        JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            result.setText(formatSize((Long) value));
        return result;
    }
        
    public static final String formatSize(Long size)
    {

        long s = (size == null) ? 0 : size.longValue();

        if(s < 0)
        {
            return "";
        }

        s /= 1024;

        // In the case where size parameter is > 0 but NOT in the kilobyte range
        // we artificially set the size to 1 KB...otherwise its 0 KB.
        //
        StringBuffer sb = new StringBuffer();
        if ((size != null) && (s == 0))
        {
            sb.append("1");
        }
        else
        if (s >= 1024) // On or over a MBytes
        {
            sb.append(s / 1024).append(',').append(s % 1024);
        }
        else {
            sb.append(s);  // Under a MBytes
        }
        
        return sb.append(" KB").toString();
    }
}
