package com.sonicsw.ma.gui.table;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.PrimitiveListTableAspectAdapter;


public class PrimitiveListTableColumn extends RowTableColumn
{
    protected Method  m_valMethod = null;

    public PrimitiveListTableColumn(int modelIndex,
                                    String  title,
                                    int     width)
    {
        super(modelIndex, title, width);

        try
        {
            m_valMethod = new PropertyDescriptor("Value", PrimitiveListTableAspectAdapter.PrimitiveModel.class, "getValue", null).getReadMethod();
        }
        catch (IntrospectionException e)
        {
            MgmtConsole.displayMessage(MgmtConsole.MESSAGE_ERROR, e.toString(), e, true);
        }
    }

    @Override
    public Object getColumnValue(Object rowModel)
    {
        try
        {
            Object v = m_valMethod.invoke(rowModel, null);

            if ((v == null) || (v instanceof Number) || (v instanceof Boolean))
            {
                return v;
            }
            else
            {
                return v.toString();
            }
        }
        catch (Exception e)
        {
            MgmtConsole.displayMessage(MgmtConsole.MESSAGE_ERROR, e.toString(), e, true);
        }

        return null;
    }
}
