/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.PrimitiveMapTableAspectAdapter;

public class PrimitiveMapTableColumn extends RowTableColumn
{
    protected boolean m_showKey   = false;
    protected Method  m_keyMethod = null;
    protected Method  m_valMethod = null;

    public PrimitiveMapTableColumn(int     modelIndex,
                                   boolean showKey,
                                   String  title,
                                   int     width)
    {
        super(modelIndex, title, width);

        try
        {
            m_showKey   = showKey;
            m_keyMethod = new PropertyDescriptor("Key",   PrimitiveMapTableAspectAdapter.PrimitiveModel.class, "getKey",   null).getReadMethod();
            m_valMethod = new PropertyDescriptor("Value", PrimitiveMapTableAspectAdapter.PrimitiveModel.class, "getValue", null).getReadMethod();
        }
        catch (IntrospectionException e)
        {
            MgmtConsole.displayMessage(MgmtConsole.MESSAGE_ERROR, e.toString(), e, true);
        }
    }

    @Override
    public Object getColumnValue(Object rowModel)
    {
        Object value = null;

        try
        {
            Object v = m_showKey ? m_keyMethod.invoke(rowModel, null)
                                 : m_valMethod.invoke(rowModel, null);

            if ((v == null) || (v instanceof Number) || (v instanceof Boolean))
            {
                value = v;
            }
            else
            {
                value = v.toString();
            }
        }
        catch (Exception e)
        {
            MgmtConsole.displayMessage(MgmtConsole.MESSAGE_ERROR, e.toString(), e, true);
        }

        return value;
    }
}
