package com.sonicsw.ma.gui.table;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class RowTableColumn extends TableColumn
{
    private boolean m_sortable;
    private boolean m_editable;
    private Class   m_columnClass;
    private boolean m_defaultVisible = true;   // Columns should always default to being visible
    
    public RowTableColumn(int               modelIndex,
                          String            headerLabel)
    {
        this(modelIndex, headerLabel, -1, null);
    }

    public RowTableColumn(int               modelIndex,
                          String            headerLabel,
                          int               width)
    {
        this(modelIndex, headerLabel, width, null);
    }

    public RowTableColumn(int               modelIndex,
                          String            headerLabel,
                          int               width,
                          TableCellRenderer cellRenderer)
    {
        this(modelIndex, headerLabel, width, cellRenderer, null);
    }

    public RowTableColumn(int               modelIndex,
                          String            headerLabel,
                          int               width,
                          TableCellRenderer cellRenderer,
                          TableCellEditor   cellEditor)
    {
        super(modelIndex, width, cellRenderer, cellEditor);

        setHeaderLabel(headerLabel);
        setSortable(true);
        setColumnClass(Object.class);
    }
    private void setHeaderLabel(String headerLabel) {
        setHeaderValue(headerLabel);
    }

    public Class getColumnClass()
    {
        return m_columnClass;
    }

    public final void setColumnClass(Class columnClass)
    {
        m_columnClass = columnClass;
    }

    public boolean isSortable()
    {
        return m_sortable;
    }

    public final void setSortable(boolean sortable)
    {
        m_sortable = sortable;
    }

    public boolean isEditable()
    {
        return m_editable;
    }

    public final void setEditable(boolean editable)
    {
        m_editable = editable;
    }

    public boolean isDefaultVisible()
    {
        return m_defaultVisible;
    }
    
    public RowTableColumn setDefaultVisible(boolean defaultVisible)
    {
        m_defaultVisible = defaultVisible;
        
        return this;
    }
    
    //-------------------------------------------------------------------------
    //
    // Abstract implementation
    //
    //-------------------------------------------------------------------------

    public Object getColumnValue(Object rowModel)
    {
        return rowModel;
    }

    public void setColumnValue(Object rowModel, Object columnValue)
    {
    }

    //-------------------------------------------------------------------------

}
