
package com.sonicsw.ma.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

import javax.swing.Icon;
import javax.swing.UIManager;

public class TableArrowIcon implements Icon
{
    private boolean isAscending;

    public TableArrowIcon(boolean isAscendingDirection)
    {
        isAscending = isAscendingDirection;
    }

    @Override
    public int getIconHeight()
    {
        return 5;
    }

    @Override
    public int getIconWidth()
    {
        return 9;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y)
    {
        // colors
        // 1 = controlDkShadow
        // 2 = infoText
        // 3 = controlLtHighlight
        if ( isAscending )
        {
            //{0, 0, 0, 2, 2, 0, 0, 0, 0},
            //{0, 0, 2, 1, 1, 1, 0, 0, 0},
            //{0, 2, 1, 1, 1, 1, 1, 0, 0},
            //{2, 1, 1, 1, 1, 1, 1, 1, 0},
            //{0, 3, 3, 3, 3, 3, 3, 3, 3}
            g.setColor((Color)UIManager.getDefaults().get("infoText"));
            g.drawLine(x, y + 3, x+3, y );
            g.drawLine(x+4, y, x+4, y );
            g.setColor((Color)UIManager.getDefaults().get("controlDkShadow"));
            g.drawLine(x+3, y+1, x+5, y+1 );
            g.drawLine(x+2, y+2, x+6, y+2 );
            g.drawLine(x+1, y+3, x+7, y+3 );
            g.setColor((Color)UIManager.getDefaults().get("controlLtHighlight"));
            g.drawLine(x+1, y+4, x+8, y+4 );
        }
        else
        {
            //{2, 2, 2, 2, 2, 2, 2, 2},
            //{0, 1, 1, 1, 1, 1, 1, 3},
            //{0, 0, 1, 1, 1, 1, 3, 0},
            //{0, 0, 0, 1, 1, 3, 0, 0},
            //{0, 0, 0, 0, 3, 0, 0, 0}
            g.setColor((Color)UIManager.getDefaults().get("infoText"));
            g.drawLine(x, y, x+7, y );
            g.setColor((Color)UIManager.getDefaults().get("controlDkShadow"));
            g.drawLine(x+1, y+1, x+6, y+1 );
            g.drawLine(x+2, y+2, x+5, y+2 );
            g.drawLine(x+3, y+3, x+4, y+3 );
            g.setColor((Color)UIManager.getDefaults().get("controlLtHighlight"));
            g.drawLine(x+7, y+1, x+4, y+4 );
        }
    }

}
