/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.mx.config.IConfigPath;

/**
 * TableAttributeMapColumnAdapter is a subclass of TableColumnAdapter
 * that uses an IConfigPath to retrieve the value for a column from
 * the row model.
 *
 * TODO:
 *
 * - Need to get column type set properly from IConfigType.
 *   Currently its just a String which doesn't help with sorting!
 *
 * NOTE: SET calls to a row currently are NOT implemented!
 */
public class TableAttributeMapColumn extends RowTableColumn
{
    protected IConfigPath m_configPath;


    public TableAttributeMapColumn(int    modelIndex,
                                   String title,
                                   int    width)
    {
        this(modelIndex, ConfigBeanModel.NAME, title, width);
    }

    public TableAttributeMapColumn(int         modelIndex,
                                   IConfigPath configPath,
                                   String      title,
                                   int         width)
    {
        this(modelIndex, configPath, title, String.class, width);
    }

    public TableAttributeMapColumn(int         modelIndex,
                                   IConfigPath configPath,
                                   String      title,
                                   Class       type,
                                   int         width)
    {
        super(modelIndex, title, width);

        setColumnClass(type);

        m_configPath = configPath;
    }

    @Override
    public Object getColumnValue(Object rowModel)
    {
        Object value = getColumnValue(rowModel, m_configPath);

        if ((value == null) && (getColumnClass() == String.class))
        {
            return "-";
        }

        return value;
    }

    /**
     * This internal method just retrieves the attribute value from the
     * row model using the config path and does no processing on the value.
     */
    protected Object getColumnValue(Object rowModel, IConfigPath path)
    {
        Object          value = null;
        ConfigBeanModel model = (ConfigBeanModel)rowModel;

        if (path.equals(ConfigBeanModel.NAME))
        {
            value = model.getViewName();
        }
        else
        {
            value = model.getData().getAttribute(path);
        }

        return value;
    }

}
