/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigServer;

/**
 * TableAttributeMapColumn is a subclass of RowTableColumn
 * that uses an IConfigPath to retrieve the value for a column from
 * the row model.
 *
 * TODO:
 *
 * - Need to get column type set properly from IConfigType.
 *   Currently its just a String which doesn't help with sorting!
 *
 * NOTE: SET calls to a row currently are NOT implemented!
 */
public class TableReferenceColumn extends RowTableColumn
{
    protected IConfigPath   m_configPath;
    protected IConfigServer m_server;


    public TableReferenceColumn(int           modelIndex,
                                IConfigServer server,
                                String        title,
                                int           width)
    {
        this(modelIndex, server, ConfigBeanModel.NAME, title, width);
    }

    public TableReferenceColumn(int           modelIndex,
                                IConfigServer server,
                                IConfigPath   configPath,
                                String        title,
                                int           width)
    {
        super(modelIndex, title, width);

        m_configPath = configPath;
        m_server     = server;
    }

    @Override
    public Object getColumnValue(Object rowModel)
    {
        Object          value   = null;
        ConfigBeanModel cbModel = (ConfigBeanModel)rowModel;

        if (m_configPath.equals(ConfigBeanModel.NAME))
        {
            value = cbModel.getViewName();
        }
        else
        if (cbModel.getData() != null)
        {
            value = cbModel.getData().getAttribute(m_configPath);
        }

        if ((value == null) && (getColumnClass() == String.class))
        {
            return "-";
        }

        return value;
    }

}
