/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellRenderer;

import com.sonicsw.ma.gui.util.ExtendedJTable;

public final class YesNoTableCellRenderer extends ExtendedJTable.ExtendedTableCellRenderer
{
    /**
     * Default constructor called by the public static method to create a single
     * instance of this renderer.
     */
    private YesNoTableCellRenderer()
    {
        setHorizontalAlignment();
    }
    
	// Initialization-on-demand holder idiom
    private static class LazyYesNoTableCellRendererHolder {
    	private static final YesNoTableCellRenderer INSTANCE = new YesNoTableCellRenderer();
    	private LazyYesNoTableCellRendererHolder() {}        
    }

	public static TableCellRenderer getInstance()
	{
	    return LazyYesNoTableCellRendererHolder.INSTANCE;
	}


    private void setHorizontalAlignment() {
        setHorizontalAlignment(SwingConstants.LEFT);
    }
    /**
     * Overridden method to display an icon and text string for a JLabel.
     */
    @Override
    public Component getTableCellRendererComponent(JTable  table,
                                                   Object  value,
                                                   boolean isSelected,
                                                   boolean hasFocus,
                                                   int     row,
                                                   int     column)
    {
        Component result = super.getTableCellRendererComponent(table, value,
                                         isSelected, hasFocus, row, column);

        String viewValue = null;

        if ((value != null) && (value instanceof Boolean))
        {
            boolean bValue = ((Boolean)value).booleanValue();

            viewValue = bValue ? "Yes" : "No";
        }

        setText(viewValue);

        return this;
    }
}
