package com.sonicsw.ma.gui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

/**
 * An icon object that draws a scaled Arrow in one of the cardinal directions.
 *
 * Code hacked out of javax.swing.plaf.basic.BasicArrowButton.java
 */
public class ArrowIcon implements Icon, SwingConstants
{
    public static final ArrowIcon ARROW_NORTH = new ArrowIcon(NORTH);
    public static final ArrowIcon ARROW_SOUTH = new ArrowIcon(SOUTH);

    private static final int DEFAULT_SIZE = 12;

    protected int direction;

    private int   size;
    private Color shadow;
    private Color darkShadow;
    private Color highlight;

    public ArrowIcon(int   direction,
                     int   size,
                     Color shadow,
                     Color darkShadow,
                     Color highlight)
    {
        setDirection(direction);

        this.size       = size;
        this.shadow     = shadow;
        this.darkShadow = darkShadow;
        this.highlight  = highlight;
    }

    public ArrowIcon(int direction, int size)
    {
        this(direction, size, UIManager.getColor("controlShadow"),
                              UIManager.getColor("controlDkShadow"),
                              UIManager.getColor("controlLtHighlight"));
    }

    public ArrowIcon(int direction)
    {
        this(direction, DEFAULT_SIZE);
    }


    public int getDirection()
    {
        return direction;
    }

    public final void setDirection(int dir)
    {
        direction = dir;
    }

    @Override
    public int getIconHeight()
    {
        return size;
    }

    @Override
    public int getIconWidth()
    {
        return getIconHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y)
    {
        int w    = getIconWidth();
        int h    = getIconHeight();
        int size = Math.max(Math.min((h - 2) / 3, (w - 2) / 3), 2);

        paintTriangle(g, x + (w / 2) - 1, y + (h / 2) - 1, size, getDirection(), true);
    }

    public void paintTriangle(Graphics g,
                              int      x,
                              int      y,
                              int      size,
                              int      direction,
                              boolean  isEnabled)
    {
        Color oldColor = g.getColor();
        int   i;
        int   j = 0;
              size = Math.max(size, 2);
        int   mid = (size / 2) - 1;

        g.translate(x, y);
        g.setColor(isEnabled ? darkShadow : shadow);

        switch (direction)
        {
            case NORTH:
                for(i = 0; i < size; i++)
                {
                    g.drawLine(mid-i, i, mid+i, i);
                }

                if(!isEnabled)  {
                    g.setColor(highlight);
                    g.drawLine(mid-i+2, i, mid+i, i);
                }
                break;
            case SOUTH:
                if(!isEnabled)  {
                    g.translate(1, 1);
                    g.setColor(highlight);
                    for(i = size-1; i >= 0; i--)   {
                        g.drawLine(mid-i, j, mid+i, j);
                        j++;
                    }
            g.translate(-1, -1);
            g.setColor(shadow);
        }

        j = 0;
                for(i = size-1; i >= 0; i--)   {
                    g.drawLine(mid-i, j, mid+i, j);
                    j++;
                }
                break;
            case WEST:
                for(i = 0; i < size; i++)      {
                    g.drawLine(i, mid-i, i, mid+i);
                }
                if(!isEnabled)  {
                    g.setColor(highlight);
                    g.drawLine(i, mid-i+2, i, mid+i);
                }
                break;
            case EAST:
                if(!isEnabled)  {
                    g.translate(1, 1);
                    g.setColor(highlight);
                    for(i = size-1; i >= 0; i--)   {
                        g.drawLine(j, mid-i, j, mid+i);
                        j++;
                    }
            g.translate(-1, -1);
            g.setColor(shadow);
                }

        j = 0;
                for(i = size-1; i >= 0; i--)   {
                    g.drawLine(j, mid-i, j, mid+i);
                    j++;
                }
        break;
            }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

}
