package com.sonicsw.ma.gui.util;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;

import com.sonicsw.ma.gui.MgmtConsole;

public class BasicAction extends    AbstractAction
                         implements PropertyChangeListener
{
    public static final String LARGE_ICON  = "LargeIcon";
    public static final String PROP_SELECTED_STATE = "PROP_SELECTED_STATE";

    private boolean m_selected = false;
    private boolean m_checkTargetValue;
    private Action  m_targetAction;

    public BasicAction()
    {
        this(null);
    }

    public BasicAction(Action targetAction)
    {
        super();

        m_checkTargetValue = false;

        setTargetAction(targetAction);
    }

    public final void setCheckTargetValue(boolean check)
    {
        m_checkTargetValue = check;
    }

    public boolean getCheckTargetValue()
    {
        return m_checkTargetValue;
    }

    //-------------------------------------------------------------------------
    //
    // Convenience methods
    //
    //-------------------------------------------------------------------------

    public String getActionCommand()
    {
        return (String)getValue(Action.ACTION_COMMAND_KEY);
    }

    public String getName()
    {
        return (String)getValue(Action.NAME);
    }

    public String getShortDescription()
    {
        return (String)getValue(Action.SHORT_DESCRIPTION);
    }

    public String getLongDescription()
    {
        return (String)getValue(Action.LONG_DESCRIPTION);
    }

    public Integer getMnemonicKey()
    {
        return (Integer)getValue(Action.MNEMONIC_KEY);
    }

    public Integer getAcceleratorKey()
    {
        return (Integer)getValue(Action.ACCELERATOR_KEY);
    }

    public Icon getSmallIcon()
    {
        return (Icon)getValue(Action.SMALL_ICON);
    }

    public Icon getLargeIcon()
    {
        return (Icon)getValue(BasicAction.LARGE_ICON);
    }

    //-------------------------------------------------------------------------

    /**
     * Returns the Icon associated with the name from the resources.
     * The resouce should be in the path.
     *
     * @param iconResourceName Name of the icon file i.e., help16.gif
     * @return the name of the image or null if the icon is not found.
     */
    protected Icon loadIcon(String iconResourceName)
    {
        Icon icon = null;
        URL  url  = getClass().getClassLoader().getResource(iconResourceName);

        if (url != null)
        {
            icon = new ImageIcon(url);

            if (icon == null)
            {
                debugErrorOutput("Failed to load icon: " + url);
            }
        }
        else
        {
            debugErrorOutput("Failed to locate icon: " + iconResourceName);
        }

        return icon;
    }

    //-------------------------------------------------------------------------

    /**
     * Override to get the value for the specified key from the target Action
     * if there is no value assigned to the RelayAction itself.
     */
    @Override
    public Object getValue(String key)
    {
        Object value = super.getValue(key);

        if (m_checkTargetValue && (value == null) && (m_targetAction != null))
        {
            value = m_targetAction.getValue(key);
        }

        return value;
    }

    public Action getTargetAction()
    {
        return m_targetAction;
    }

    public final void setTargetAction(Action newTargetAction)
    {
        if (m_targetAction != null)
        {
            m_targetAction.removePropertyChangeListener(this);
        }

        m_targetAction = newTargetAction;

        if (m_targetAction != null)
        {
            m_targetAction.addPropertyChangeListener(this);
        }

        if (m_targetAction != null)
        {
            super.setEnabled(isEnabled());
        }
    }

    //-------------------------------------------------------------------------
    //
    // PropertyChangeListener
    //
    //-------------------------------------------------------------------------

    @Override
    public void propertyChange(PropertyChangeEvent evt)
    {
        if ((m_targetAction != null) &&
            (evt.getSource() == m_targetAction) &&
            evt.getPropertyName().equals("enabled"))
        {
            super.setEnabled(isEnabled());
        }
    }

    //-------------------------------------------------------------------------

    @Override
    public void actionPerformed(ActionEvent evt)
    {
        if ((m_targetAction != null) && m_targetAction.isEnabled())
        {
            m_targetAction.actionPerformed(evt);
        }
    }

    //-------------------------------------------------------------------------

    @Override
    public boolean isEnabled()
    {
        return (m_targetAction != null) ? m_targetAction.isEnabled() : super.isEnabled();
    }

    @Override
    public void setEnabled(boolean newValue)
    {
        if (m_targetAction != null)
        {
            m_targetAction.setEnabled(newValue);
        }
        else
        {
            super.setEnabled(newValue);
        }
    }

    //-------------------------------------------------------------------------

    public boolean isSelected()
    {
        return m_selected;
    }

    public void setSelected(boolean selected)
    {
        if (m_selected != selected)
        {
            boolean oldSelected = m_selected;

            m_selected = selected;

            firePropertyChange("selected", new Boolean(oldSelected),
                                           new Boolean(selected));
        }
    }

    public boolean canDisplay() { return true; }

    //-------------------------------------------------------------------------

    private void debugErrorOutput(String value)
    {
        if (MgmtConsole.DEVELOPER_MODE)
        {
            System.err.println(value);
        }
    }
}
