package com.sonicsw.ma.gui.util;

import javax.swing.Action;

import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;

/**
 * Represents an action that loads its name, tooltip, and other
 * properties from a resource bundle.
 */
public class BasicPluginAction extends BasicResourceAction
{
    protected IPluginContext m_context;
    protected IPlugin        m_plugin;

    
    public BasicPluginAction(String resourceId)
    {
    	super(resourceId, null);
    }
    
    public BasicPluginAction(IPluginContext context,
                             IPlugin        plugin,
                             Action         targetAction,
                             String         resourceId)
    {
        super(resourceId, targetAction);

        m_context = context;
        m_plugin  = plugin;
    }

    public BasicPluginAction(IPluginContext context,
                             IPlugin        plugin,
                             String         resourceId)
    {
        this(context, plugin, null, resourceId);
    }

    public BasicPluginAction(IPluginContext context, String resourceId)
    {
        this(context, null, resourceId);
    }

    public BasicPluginAction(IPlugin plugin, String resourceId)
    {
        this((plugin != null) ? plugin.getPluginContext() : null,
             plugin,
             resourceId);
    }

    public IPluginContext getContext()
    {
        return m_context;
    }

    public IPlugin getPlugin()
    {
        return m_plugin;
    }

	public void setContext(IPluginContext context) {
		this.m_context = context;
	}

	public void setPlugin(IPlugin plugin) {
		this.m_plugin = plugin;
	}
}