package com.sonicsw.ma.gui.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;

/**
 * AHJ
 * This code exists because Swing totally sucks!!! :(
 * As of 1.4.1 there is NO support for select state in the Action mechanism.
 * This means manual synchronization of multiple components using the same
 * action....not good.
 * I hacked this code out of the AbstractButton and added a "selected" property
 * type...and guess what...it works :)
 *
 * When Sun get there act together and fix this crap then we can remove this
 * class.
 *
 * Sun Bug Id: 4133141
 */
public class ButtonActionPropertyChangeListener implements PropertyChangeListener
{
    private WeakReference target;
    private Action action;
    
    private static class ReferenceQueueHolder 
    {
        private final static ReferenceQueue INSTANCE = new ReferenceQueue();
    }

    public ButtonActionPropertyChangeListener(JComponent c, Action a)
    {
        super();
        setTarget(c);
        this.action = a;
    }

    public final void setTarget(JComponent c)
    {
        // Check to see whether any old buttons have
        // been enqueued for GC.  If so, look up their
        // PCL instance and remove it from its Action.
        OwnedWeakReference r;
        while ((r = (OwnedWeakReference)ReferenceQueueHolder.INSTANCE.poll()) != null)
        {
            ButtonActionPropertyChangeListener oldPCL = (ButtonActionPropertyChangeListener)r.getOwner();
            Action oldAction = oldPCL.getAction();
            if (oldAction != null)
            {
                oldAction.removePropertyChangeListener(oldPCL);
            }
        }
        this.target = new OwnedWeakReference(c, ReferenceQueueHolder.INSTANCE, this);
    }

    public JComponent getTarget() {
        return (JComponent)this.target.get();
    }

    public Action getAction() {
          return action;
    }

    private static class OwnedWeakReference extends WeakReference
    {
        private Object owner;

        OwnedWeakReference(Object target, ReferenceQueue queue, Object owner) {
        super(target, queue);
        this.owner = owner;
        }

        public Object getOwner() {
            return owner;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e)
    {
        String propertyName = e.getPropertyName();
        AbstractButton button = (AbstractButton)getTarget();
        if (button == null) {   //WeakRef GC'ed in 1.2
        Action action = (Action)e.getSource();
        action.removePropertyChangeListener(this);
        }
        else
        {
            if (e.getPropertyName().equals(Action.NAME))
            {
                Boolean hide = (Boolean)button.getClientProperty("hideActionText");

                if (hide == null || hide == Boolean.FALSE) {
            String text = (String) e.getNewValue();
            button.setText(text);
            button.repaint();
        }
        } else if (e.getPropertyName().equals(Action.SHORT_DESCRIPTION)) {
        String text = (String) e.getNewValue();
        button.setToolTipText(text);
        } else if (propertyName.equals("enabled")) {
        Boolean enabledState = (Boolean) e.getNewValue();
        button.setEnabled(enabledState.booleanValue());
        button.repaint();
        } else if (propertyName.equals("selected"))
        {
            Boolean selectedState = (Boolean) e.getNewValue();
            button.setSelected(selectedState.booleanValue());
            button.repaint();
        } else if (e.getPropertyName().equals(Action.SMALL_ICON)) {
        Icon icon = (Icon) e.getNewValue();
        button.setIcon(icon);
        button.invalidate();
        button.repaint();
        } else if (e.getPropertyName().equals(Action.MNEMONIC_KEY)) {
        Integer mn = (Integer) e.getNewValue();
        button.setMnemonic(mn.intValue());
        button.invalidate();
        button.repaint();
            }
            else
            if (e.getPropertyName().equals(Action.ACTION_COMMAND_KEY))
            {
                button.setActionCommand((String)e.getNewValue());
            }
        }
    }
}
