package com.sonicsw.ma.gui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

import javax.swing.Icon;

public class ColorIcon
    implements Icon
{
    public static final ColorIcon GREEN = new ColorIcon(Color.green);
    public static final ColorIcon RED = new ColorIcon(Color.red);
    public static final ColorIcon BLUE = new ColorIcon(Color.blue);
    public static final ColorIcon YELLOW = new ColorIcon(Color.yellow);
    public static final ColorIcon ORANGE = new ColorIcon(Color.orange);

    private static final int BORDER = 0;

    private Color m_borderColor = Color.LIGHT_GRAY;
    private Color m_color;
    private int m_nWidth;
    private int m_nHeight;

    public ColorIcon(Color color)
    {
        this(color, 16);
    }

    public ColorIcon(Color color, int nSize)
    {
        this(color, nSize, nSize);
    }

    public ColorIcon(Color color, int nWidth, int nHeight)
    {
        setColor(color);
        m_nWidth = nWidth;
        m_nHeight = nHeight;
    }

    public Color getColor()
    {
        return m_color;
    }

    public final void setColor(Color color)
    {
        m_color = color;
    }

    public Color getBorderColor()
    {
        return m_borderColor;
    }

    public void setBorderColor(Color borderColor)
    {
        m_borderColor = borderColor;
    }

    @Override
    public int getIconHeight()
    {
        return m_nHeight;
    }

    @Override
    public int getIconWidth()
    {
        return m_nWidth;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y)
    {
        g.setColor(m_color);
        g.fillRect(x + BORDER, y + BORDER, getIconWidth() - (2 * BORDER), getIconHeight() - (2 * BORDER));

        g.setColor(m_borderColor);
        g.drawRect(x + BORDER, y + BORDER, getIconWidth() - (2 * BORDER), getIconHeight() - (2 * BORDER));
    }
}