package com.sonicsw.ma.gui.util;

import java.awt.Color;

public class ColorSeries
{
    ////////////////////////////////////////////////////////////////////////////
    //
    // Attributes

    protected Color [] m_aColors;
    protected int      m_nIndex = 0;
    protected double   m_dPercent = 0.15;

    protected static Color[] sm_aColors = {
            Color.red, Color.green, Color.blue, Color.yellow };

    ////////////////////////////////////////////////////////////////////////////
    //
    // Methods

    public ColorSeries (double dPercent)
    {
        this ();
        m_dPercent = dPercent;
    }

    public ColorSeries ()
    {
        m_aColors = new Color [sm_aColors.length];
        for (int n = 0; n < m_aColors.length; n++)
        {
            m_aColors[n] = sm_aColors[n];
        }
    }

    public ColorSeries (Color [] aColors)
    {
        m_aColors = aColors;
    }

    public ColorSeries (Color [] aColors, double dPercent)
    {
        this (aColors);
        m_dPercent = dPercent;
    }

    public Color getNextColor ()
    {
        // Get the current color.
        Color c = m_aColors [m_nIndex++];

        // See if we were on the last color.
        if (m_nIndex >= m_aColors.length)
        {
            // Reset the index.
            m_nIndex = 0;

            // Soften the colors.
            for (int n = 0; n < m_aColors.length; n++)
            {
                m_aColors[n] = ColorUtils.darken (m_aColors[n], m_dPercent);
            }
        }

        return (c);
    }
}
