/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * ComponentTracker provides static methods that let you keep track off
 * any number of Component instances using the component class type and
 * a unique id to reference them. It also provides a means of attaching
 * "data" to the component item.
 *
 * Very useful for keeping track of child forms.
 */
public class ComponentTracker
{
  private static ComponentTracker instance = null;

  protected ArrayList m_list;

  private ComponentTracker()
  {
    m_list = new ArrayList();
  }

  protected ComponentTrackerItem findItem(Class componentClass, Object componentId)
  {
    ComponentTrackerItem item = null;
    Iterator             i    = m_list.iterator();

    while (i.hasNext() && (item == null))
    {
      ComponentTrackerItem ctItem = (ComponentTrackerItem)i.next();

      if (ctItem.getComponent().getClass().equals(componentClass) &&
          ctItem.getId().equals(componentId))
    {
        item = ctItem;
    }
    }
    return item;
  }

  protected ComponentTrackerItem setItem(Component component, Object id, Object data)
  {
    ComponentTrackerItem item = findItem(component.getClass(), id);

    if (item == null)
    {
      item = new ComponentTrackerItem(component, id, data);

      m_list.add(item);
    }
    else
    {
      item.setData(data);
    }
    return item;
  }

  protected ComponentTrackerItem removeItem(Class componentClass, Object componentId)
  {
    ComponentTrackerItem item = findItem(componentClass, componentId);

    if (item != null)
    {
      m_list.remove(item);
    }
    return item;
  }

  protected void removeAllItems(Class componentClass)
  {
    for (int i = m_list.size()-1; i >=0 ; i--)
    {
      ComponentTrackerItem item  = (ComponentTrackerItem)m_list.get(i);
      Class                match = item.getComponent().getClass();

      if ((componentClass == null) || componentClass.equals(match))
    {
        m_list.remove(i);
    }
    }
  }

  //---------------------------------------------------------------------------

  private static final synchronized ComponentTracker getInstance()
  {
    if (instance == null)
    {
        instance = new ComponentTracker();
    }

    return instance;
  }

  public static final ComponentTrackerItem find(Class componentClass, Object componentId)
  {
    return getInstance().findItem(componentClass, componentId);
  }

  public static final ComponentTrackerItem set(Component component, Object id, Object data)
  {
    return getInstance().setItem(component, id, data);
  }

  public static final ComponentTrackerItem set(Component component, Object id)
  {
    return set(component, id, null);
  }

  public static final ComponentTrackerItem remove(Class componentClass, Object componentId)
  {
    return getInstance().removeItem(componentClass, componentId);
  }

  protected void removeAll(Class componentClass)
  {
    getInstance().removeAllItems(componentClass);
  }

  protected void removeAll()
  {
    removeAll(null);
  }

  //---------------------------------------------------------------------------

}

