/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.util;

import java.awt.Component;

/**
 * The ComponentTrackerItem stores all the information needed to
 * track a single component item.
 */
public class ComponentTrackerItem
{
  protected Component component;
  protected Object    id;
  protected Object    data;

  public ComponentTrackerItem(Component component, Object id)
  {
    this(component, id, null);
  }

  public ComponentTrackerItem(Component component, Object id, Object data)
  {
    this.component = component;
    this.id        = id;
    this.data      = data;
  }

  public Component getComponent()
  {
    return component;
  }

  public Object getId()
  {
    return id;
  }

  public Object getData()
  {
    return data;
  }

  public void setData(Object data)
  {
    this.data = data;
  }

  @Override
public String toString()
  {
    return "ComponentTrackerItem [id=" + getId() +
                        ", component=" + getComponent() +
                             ", data=" + getData() + "]";
  }

}

