/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.util;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

import javax.swing.filechooser.FileFilter;

/**
 * <p>Title: Generic FileFilter for use with the JFileChooser.
 * This filter allows extension/description pairs to be entered allowing
 * both simple and complex filters to be defined.
 *
 * e.g. JPG        JPEG Image Files    >  "JPEG Image Files (*.jpg)"
 *      JPG, BMP   All Image Files     >  "All Image Files"</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */
public class DefaultFileFilter extends FileFilter
{
    public static final DefaultFileFilter XML = new DefaultFileFilter("xml", "XML Files");

    private Set    m_set;
    private String m_description;

    /**
     * @param extension    A single extension, or multiple extensions that are
     *                     semi-colon or comma separated.
     * @param description
     */
    public DefaultFileFilter(String extension, String description)
    {
        super();

        m_set = new HashSet();

        StringTokenizer st = new StringTokenizer(extension, ";,");
        while (st.hasMoreTokens())
        {
            m_set.add(st.nextToken());
        }

        if (st.countTokens() > 1)
        {
            m_description = description + " (*." + extension + ")";
        }
        else
        {
            m_description = description;
        }
    }

    public DefaultFileFilter(String[] extension, String description)
    {
        super();

        m_set = new HashSet();
        for (int i = 0; i < extension.length; i++)
        {
            m_set.add(extension[i]);
        }

        m_description = description;
    }

    public DefaultFileFilter(Set set, String description)
    {
        super();

        m_set = Collections.unmodifiableSet(set);
        m_description = description;
    }

    @Override
    public boolean accept(File f)
    {
        if (f.isDirectory())
        {
            return true;
        }

        String ext = f.toString().toLowerCase();
        int index = ext.lastIndexOf('.');

        if (index == -1)
        {
            return false;
        }

        ext = ext.substring(index + 1);

        return m_set.contains(ext);
    }

    @Override
    public String getDescription()
    {
        return m_description;
    }
}
