package com.sonicsw.ma.gui.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
/**
 * <p>Title: DescriptionPanel</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2002, Sonic Software Corporation</p>
 * @author Jeffrey S. Pace
 * @version 1.0
 */
public class DescriptionPanel extends JPanel
{
    private static final String SEPARATOR = " - ";

    protected JLabel m_labelDescription = null;
    protected JLabel m_labelExtendedDescription = null;
    protected JLabel m_labelImage = null;
    protected Font m_fontDescription = new Font("Dialog", Font.BOLD, 16);
    protected Font m_fontExtendedDescription = new Font("Dialog", Font.PLAIN, 16);

    public DescriptionPanel(String strDescription)
    {
        this (strDescription, Color.gray, Color.white);
    }

    public DescriptionPanel(String strDescription, Color color)
    {
        this (strDescription, color, Color.white);
    }

    /**
     * DescriptionPanel
     * @param strDescription display text
     */
    public DescriptionPanel(String strDescription, Color color, Color colorText)
    {
        setupGUI(color, colorText);
        setText(strDescription);
    }

    /**
     * setText
     * @param strDescription display text
     */
    public final void setText(String strDescription)
    {
        m_labelDescription.setText(strDescription);
    }

    /**
     * setExtendedText
     * @param strExtendedDescription extended display text
     */
    public void setExtendedText(String strExtendedDescription)
    {
        if (strExtendedDescription != null && strExtendedDescription.equals("") == false)
        {
            ensureDescriptionSeparator();
        }
        else
        {
            removeSeparator();
        }
        m_labelExtendedDescription.setText(strExtendedDescription);
        m_labelExtendedDescription.setToolTipText(strExtendedDescription);
    }

    /**
     * getDescriptionFont
     * @return font for the description text
     */
    public Font getDescriptionFont() { return m_fontDescription; }

    /**
     * setDescriptionFont
     * @param fontDescription font for the description text
     */
    public void setDescriptionFont(Font fontDescription) { m_fontDescription = fontDescription; }

    /**
     * getExtendedDescriptionFont
     * @return font for the extended description text
     */
    public Font getExtendedDescriptionFont() { return m_fontExtendedDescription; }

    /**
     * setExtendedDescriptionFont
     * @param fontExtendedDescription font for the extended description text
     */
    public void setExtendedDescriptionFont(Font fontExtendedDescription) { m_fontExtendedDescription = fontExtendedDescription; }

    /**
     * setIcon
     * @param icon icon to display on the right side of the panel
     */
    public void setIcon(Icon icon)
    {
        m_labelImage.setIcon(icon);
    }

    /**
     * getDescriptionLabel
     * @return JLabel holding the description text
     */
    public JLabel getDescriptionLabel() { return m_labelDescription; }

    /**
     * ensureDescriptionSeparator
     */
    protected void ensureDescriptionSeparator()
    {
        if (m_labelDescription != null)
        {
            if (m_labelDescription.getText().endsWith(SEPARATOR) == false)
            {
                m_labelDescription.setText(m_labelDescription.getText() + SEPARATOR);
            }
        }
    }

    /**
     * removeSeparator
     */
    protected void removeSeparator()
    {
        if (m_labelDescription != null)
        {
            if (m_labelDescription.getText().endsWith(SEPARATOR))
            {
                String strText = m_labelDescription.getText().substring(0, m_labelDescription.getText().length() - SEPARATOR.length());
                m_labelDescription.setText(strText);
            }
        }
    }

    private void setupGUI(Color color, Color colorText)
    {
        setLayout(new BorderLayout(0,0));

        // text label on the gray panel...
        m_labelDescription = new JLabel();
        m_labelDescription.setFont(m_fontDescription);
        m_labelDescription.setBorder(new CompoundBorder(m_labelDescription.getBorder(),
                new EmptyBorder(0,JPartitionPanel.BORDER_SIZE,0,0)));

        m_labelDescription.setForeground(colorText);

        // extended text label on the gray panel...
        m_labelExtendedDescription = new JLabel();
        m_labelExtendedDescription.setFont(m_fontExtendedDescription);
        m_labelExtendedDescription.setBorder(new CompoundBorder(m_labelDescription.getBorder(),
                new EmptyBorder(0,0,0,JPartitionPanel.BORDER_SIZE)));

        m_labelExtendedDescription.setForeground(Color.white);
        m_labelExtendedDescription.setMinimumSize(new Dimension(0, m_labelExtendedDescription.getMinimumSize().height));

        // label panel...
        final JPanel panelLabel = new JPanel();
        panelLabel.setLayout(new BorderLayout(0,0));
        panelLabel.add(BorderLayout.WEST, m_labelDescription);
        panelLabel.add(BorderLayout.CENTER, m_labelExtendedDescription);
        panelLabel.setBackground(color);
        panelLabel.setBorder(BorderFactory.createEmptyBorder(2,0,2,0));
        add(BorderLayout.NORTH, panelLabel);

        // image panel...
        m_labelImage = new JLabel();
        m_labelImage.setBorder(new CompoundBorder(m_labelImage.getBorder(),
            new EmptyBorder(1,JPartitionPanel.BORDER_SIZE, 1,JPartitionPanel.BORDER_SIZE)));

        panelLabel.add(BorderLayout.EAST, m_labelImage);
    }
}
