package com.sonicsw.ma.gui.util;

import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EditableTablePanel extends EditableComponentPanel
{
    public EditableTablePanel ()
    {
        this(true, true, true);
    }

    public EditableTablePanel (boolean bAdd, boolean bEdit, boolean bRemove)
    {
        super(bAdd, bEdit, bRemove);

        setObjectIcon(ResourceManager.getIcon(getClass(), "file"));
    }

    @Override
    protected void init (String nBorder, int nButtonStyle)
    {
        init(nBorder, nButtonStyle, true);
    }

    @Override
    protected void init (String nBorder, boolean bCreateScroller, int nButtonStyle)
    {
        init(nBorder, bCreateScroller, nButtonStyle, true);
    }

    @Override
    protected void init (String nBorder, boolean bCreateScroller, int nButtonStyle, boolean bAutoEdit)
    {
        super.init(nBorder, bCreateScroller, nButtonStyle, bAutoEdit);

        // Add the selection listener.
        ((JTable) getComponent()).getSelectionModel().addListSelectionListener(new ListSelectionListener()
        {
            @Override
            public void valueChanged(ListSelectionEvent e)
            {
                selectionChanged(e);
            }
        });
    }

    @Override
    protected void init (String nBorder, int nButtonStyle, boolean bAutoEdit)
    {
        init(nBorder, true, nButtonStyle, bAutoEdit);
    }

    protected void selectionChanged (ListSelectionEvent e)
    {
        setUIState();
    }

    @Override
    protected void setUIState()
    {
        super.setUIState();
    }

    @Override
    protected boolean canEnableEdit()
    {
        boolean bEnable = false;

        int nRow = ((JTable) getComponent()).getSelectedRow();
        if (nRow != -1)
        {
            bEnable = true;
        }

        return bEnable;
    }

    @Override
    protected boolean canEnableRemove()
    {
        boolean bEnable = false;

        int nRows = ((JTable) getComponent()).getSelectedRowCount();
        if (nRows != 0)
        {
            bEnable = true;
        }

        return bEnable;
    }
}
