package com.sonicsw.ma.gui.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

import javax.swing.Icon;
import javax.swing.ImageIcon;

/**
 * <p>Title: ExtendedImageIcon</p>
 * <p>Description: Extends the behavior of ImageIcon</p>
 * @author Jeffrey S. Pace
 * @version 1.0
 */
public class ExtendedImageIcon
    extends ImageIcon
{
    protected int   m_nHeight = 0;
    protected int   m_nWidth = 0;
    protected Stack m_icons = new Stack();
    protected Image m_image;

    /**
     * ExtendedImageIcon
     * @param icon
     */
    public ExtendedImageIcon (Icon icon) { addOverlay (icon); }

    /**
     * ExtendedImageIcon
     * @param iconBase base icon
     * @param iconOverlay icon to overlay on base
     */
    public ExtendedImageIcon (Icon iconBase, Icon iconOverlay) { addOverlay (iconBase); addOverlay (iconOverlay); }

    /**
     * ExtendedImageIcon
     * @param icons array of icons to stack.
     */
    public ExtendedImageIcon (ArrayList icons)
    {
        int nIcons = icons.size();
        for (int nIcon = 0; nIcon < nIcons; nIcon++)
        {
            addOverlay ((Icon)icons.get(nIcon));
        }
    }

    /**
     * addOverlay
     * @param icon icon to overlay
     */
    public final void addOverlay (Icon icon)
    {
        if (icon != null)
        {
            int nWidth = icon.getIconWidth();
            int nHeight = icon.getIconWidth();

            m_nHeight = Math.max (m_nHeight, nHeight);
            m_nWidth = Math.max (m_nWidth, nWidth);

            m_icons.push (icon);
            m_image = null;
        }
    }

    /**
     * getIconWidth
     * @return icon width
     */
    @Override
    public int getIconWidth () { return (m_nWidth); }

    /**
     * getIconHeight
     * @return icon height
     */
    @Override
    public int getIconHeight () { return (m_nHeight); }
    @Override
    public void paintIcon (Component c, Graphics g, int nX, int nY)
    {
        Iterator icons = m_icons.iterator();
        while (icons.hasNext())
        {
            Icon icon = ((Icon)icons.next());
            icon.paintIcon (c, g, nX, nY);
        }
    }

    /**
     * getImage
     * @return gets the icons associated Image
     */
    @Override
    public Image getImage()
    {
        if (m_image == null)
        {
            m_image = createImage (this, component);
        }

        return (m_image);
    }

    /**
     * createImage
     * @param icon icon you want an Image from
     * @return the icons associated Image
     */
    public static Image createImage (Icon icon)
    {
        return createImage(icon, null);
    }

    public static Image createImage (Icon icon, Component c)
    {
        // Make sure there is something.
        if (icon == null)
        {
            return (null);
        }

        // Render the icon into a bitmap image.
        BufferedImage imageCopy = new BufferedImage (icon.getIconWidth(), icon.getIconHeight(), BufferedImage.TYPE_INT_ARGB);
        Graphics g = imageCopy.getGraphics();
        icon.paintIcon (c, g, 0, 0);

        return (imageCopy);
    }
}
