package com.sonicsw.ma.gui.util;

import java.awt.Insets;

import javax.swing.JButton;
import javax.swing.UIManager;

public class ExtendedJButton
    extends JButton
{
    public ExtendedJButton()
    {
        super();

        init();
    }

    public ExtendedJButton(javax.swing.Action a)
    {
        super(a);

        init();
    }

    public ExtendedJButton(javax.swing.Icon icon)
    {
        super(icon);

        init();
    }

    public ExtendedJButton(String text)
    {
        super(text);

        init();
    }

    public ExtendedJButton(String text, javax.swing.Icon icon)
    {
        super(text, icon);

        init();
    }

    protected final void init()
    {
        // only enable this for Windows...
        if (UIManager.getLookAndFeel().getName().equals("Windows") == true)
        {
            // set default state...
            setBorderPainted(false);
            setMargin(new Insets(1, 1, 1, 1));

            addMouseListener(new java.awt.event.MouseAdapter()
            {
                @Override
                public void mouseEntered(java.awt.event.MouseEvent e)
                {
                    // paint the border...
                    if (isEnabled())
                    {
                        setBorderPainted(true);
                    }
                }

                @Override
                public void mouseExited(java.awt.event.MouseEvent e)
                {
                    // remove the border...
                    setBorderPainted(false);
                }
            });
        }
    }
}