package com.sonicsw.ma.gui.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.table.TableColumn;

import com.sonicsw.ma.gui.table.ModelListTableModel;

/**
 * <p>Title: FilterTableModel</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: Sonic Software Corporation </p>
 * @author Jeffrey S. Pace
 * @version 1.0
 */

public class FilterTableModel
    extends ModelListTableModel
{
    protected boolean m_bFilterIsActive;
    protected List m_listFilteredData = new ArrayList();

    /**
     * FilterTableModel
     * @param tableColumns
     */
    public FilterTableModel(TableColumn[] tableColumns)
    {
        this(tableColumns, new ArrayList());
    }

    /**
     * FilterTableModel
     * @param tableColumns
     * @param contents
     */
    public FilterTableModel(TableColumn[] tableColumns, List contents)
    {
        this(tableColumns, contents, false);
    }

    /**
     * FilterTableModel
     * @param tableColumns
     * @param contents
     * @param bFilterIsActive
     */
    public FilterTableModel(TableColumn[] tableColumns, List contents, boolean bFilterIsActive)
    {
        super(tableColumns, contents);
        m_bFilterIsActive = bFilterIsActive;
    }

    /**
     * activateFilter
     * @param filterIsActive defines if the filter is active
     */
    public void activateFilter(boolean bFilterIsActive)
    {
        m_bFilterIsActive = bFilterIsActive;
    }

    /**
     * isFilterActivated
     * @return
     */
    public boolean isFilterActivated()
    {
        return m_bFilterIsActive;
    }

    /**
     * isFiltered
     * @param node
     * @return
     */
    public boolean isFiltered(Object obj)
    {
        boolean bIsFilterable = obj instanceof IFilterable;
        return bIsFilterable ? !((IFilterable)obj).canDisplay(this) : false;
    }

    /**
     * filterData
     * @param bFilter
     */
    public void filterData(boolean bFilter)
    {
        if (isFilterActivated())
        {
            if (bFilter == true)
            {
                // filter out the view...
                Iterator iter = m_listView.iterator();

                while (iter.hasNext())
                {
                    Object obj = iter.next();

                    if (isFiltered(obj))
                    {
                        // add to filtered list...
                        m_listFilteredData.add(obj);
                    }
                }

                // iterate filtered list to remove from the view...
                iter = m_listFilteredData.iterator();

                while (iter.hasNext())
                {
                    delete(iter.next());
                }
            }
            else
            {
                // restore filtered contents - if any...
                Iterator i = m_listFilteredData.iterator();

                while (i.hasNext())
                {
                    addRow(i.next());
                }

                m_listFilteredData.clear();
            }
        }

        // notify all who care...
        fireTableStructureChanged();
    }
}