package com.sonicsw.ma.gui.util;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;

public class JBasicCheckBoxMenuItem
    extends JCheckBoxMenuItem
{
    Object m_userObject;

    public JBasicCheckBoxMenuItem(BasicAction action)
    {
        super(action);
    }

    public Object getUserObject()
    {
        return m_userObject;
    }

    public void setUserObject(Object object)
    {
        m_userObject = object;
    }

    @Override
    public Icon getIcon()
    {
        Icon icon = super.getIcon();

        if (icon == null)
        {
            icon = ResourceManager.getIcon(getClass(), "blank");
        }

        return icon;
    }

    @Override
    public String getToolTipText()
    {
        return null;
    }

    public void setToolTipText()
    {
        // intentionally ignored...
    }

    @Override
    protected void fireActionPerformed(ActionEvent evt)
    {
        // Because we are dealing with a CheckBox-style component, an action is
        // generated per selection state change.
        // We override here to pass the selection state on to the attached
        // action.
        ((BasicAction) getAction()).setSelected(isSelected());

        super.fireActionPerformed(evt);
    }

    @Override
    protected void configurePropertiesFromAction(Action a)
    {
        String[] types =
            {Action.SMALL_ICON,
            Action.MNEMONIC_KEY,
            Action.NAME,
            Action.ACCELERATOR_KEY,
            Action.LONG_DESCRIPTION,
            "enabled"};

        Helper.configurePropertiesFromAction(this, a, types);
    }

    @Override
    protected PropertyChangeListener createActionPropertyChangeListener(Action a)
    {
        return new ButtonActionPropertyChangeListener(this, a);
    }
}