/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.util;

import java.awt.Component;
import java.awt.event.MouseListener;

import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

/**
 * <p>Title: JBasicMenu</p>
 * <p>Description:
 * A specialized JMenu, this class accepts only BasicActions and intercepts
 * menu events so that its child menu items can be updated (enabled/disabled)
 * before display.
 * The tooltip and icon methods are overridden so that popups and toolbar icons
 * are not displayed.
 * </p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: Sonic Software</p>
 * @author Huw Jones
 * @version 1.0
 */
public class JBasicMenu
    extends JMenu
    implements MenuListener
{
    private MouseListener m_mouseListener;

    public JBasicMenu(BasicAction action)
    {
        super(action);
        addMenuListener();
    }

    private void addMenuListener() {
        addMenuListener(this);
    }
    
    public void add(BasicAction action)
    {
        if (action.canDisplay() == false)
        {
            // not allowed to display action...
            return;
        }

        add(new JBasicMenuItem(action));
    }

    @Override
    public Icon getIcon()
    {
        Icon icon = super.getIcon();

        if (getParent() instanceof JMenuBar == false)
        {
            icon = ResourceManager.getIcon(getClass(), "blank");
        }

        return icon;
    }

    @Override
    public String getToolTipText()
    {
        return null;
    }

    public void setToolTipText()
    {
        // intentionally ignored...
    }

    @Override
    protected void configurePropertiesFromAction(Action a)
    {
        String[] types =
                         {Action.MNEMONIC_KEY, Action.NAME, Action.ACCELERATOR_KEY, "enabled"};

        Helper.configurePropertiesFromAction(this, a, types);
    }

    //-------------------------------------------------------------------------
    //
    // MenuListener implementation
    //
    //-------------------------------------------------------------------------

    @Override
    public void menuCanceled(MenuEvent evt)
    {
        // intentionally ignored...
    }

    @Override
    public void menuDeselected(MenuEvent evt)
    {
        // intentionally ignored...
    }

    @Override
    public void menuSelected(MenuEvent evt)
    {
        for (int i = 0; i < getMenuComponentCount(); i++)
        {
            Component item = getMenuComponent(i);

            if (item instanceof AbstractButton)
            {
                Action action = ((AbstractButton) item).getAction();

                if (action != null)
                {
                    item.setEnabled(action.isEnabled());
                }
            }
        }

        if (m_mouseListener != null)
        {
            registerMouseListener();
        }
    }

    public void setMouseListener(MouseListener mouseListener)
    {
        m_mouseListener = mouseListener;
    }

    protected void registerMouseListener()
    {
        registerMouseListener(this);
    }

    private void registerMouseListener(JMenu menu)
    {
        menu.addMouseListener(m_mouseListener);

        for (int i = 0; i < menu.getItemCount(); i++)
        {
            JMenuItem item = menu.getItem(i);

            if (item != null)
            {
                if (item instanceof JMenu)
                {
                    registerMouseListener((JMenu) item);
                }
                else
                {
                    item.removeMouseListener(m_mouseListener);
                    item.addMouseListener(m_mouseListener);
                }
            }
        }
    }
}