package com.sonicsw.ma.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;

import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;

import modelobjects.layout.PartitionLayout;

public class JButtonPanel extends JPanel
{
  private static final String REF_REMAINDER = "_remainder";

  protected ArrayList m_list;

  public JButtonPanel()
  {
    this(false);
  }

  public JButtonPanel(boolean vertical)
  {
    this(vertical, JPartitionPanel.DEFAULT_GAP_SIZE,
                   JPartitionPanel.DEFAULT_TB_EDGE_GAP,
                   JPartitionPanel.DEFAULT_LR_EDGE_GAP);
  }

  public JButtonPanel(boolean vertical, int gapSize, int tbEdgeGap, int lrEdgeGap)
  {
    super();

    setButtonPanelLayout(vertical, gapSize, tbEdgeGap, lrEdgeGap);

    m_list = new ArrayList();
  }

  private void setButtonPanelLayout(boolean vertical, int gapSize, int tbEdgeGap, int lrEdgeGap) {
      setLayout(new PartitionLayout(vertical, "", gapSize, tbEdgeGap, lrEdgeGap, getClass().getName()));  
  }
  
  @Override
protected void addImpl(Component comp, Object constraints, int index)
  {
    String name = "unknown";

    if (comp instanceof JButton)
    {
      JButton btn = (JButton)comp;

      name = btn.getActionCommand();

      if ((name == null) || (name.trim().length() == 0))
    {
        name = (String)btn.getAction().getValue(Action.NAME);
    }
    }
    else
    if (comp instanceof JSeparator)
    {
        name = "separator";
    }
    else
    if (comp instanceof JRemainderPanel)
    {
        name = REF_REMAINDER;
    }


    m_list.add(new ButtonPanelItem(name, (Container)comp));

    updatePartitionSpecs();

    super.addImpl(comp, constraints, index);
  }

  public void addSeparator(int orientation)
  {
    JSeparator sep = new JSeparator(orientation);

    add(new JSeparator(orientation));
  }

  public void addSeparator()
  {
    addSeparator(((PartitionLayout)getLayout()).isVertical()
                  ? SwingConstants.HORIZONTAL : SwingConstants.VERTICAL);
  }

  public void addButton(String actionCommand)
  {
    JButton btn = new JButton(actionCommand);

    btn.setActionCommand(actionCommand);

    add(btn);
  }

  public void addButton(Action action)
  {
    add(new JBasicButton(action));
  }

  public void addButton(String[] actionCommand)
  {
    for (int i = 0; i < actionCommand.length; i++)
    {
        addButton(actionCommand[i]);
    }
  }

  public void addRemainder()
  {
    add(new JRemainderPanel());
  }

  public Action getAction(String actionCmd)
  {
    return getAction(Action.ACTION_COMMAND_KEY, actionCmd);
  }

  public Action getAction(String actionKey, Object actionValue)
  {
    JButton button = getButton(actionKey, actionValue);

    return (button != null) ? button.getAction() : null;
  }

  public JButton getButton(String actionCmd)
  {
    return getButton(Action.ACTION_COMMAND_KEY, actionCmd);
  }

  public JButton getButton(String actionKey, Object actionValue)
  {
    JButton  res = null;
    Iterator i   = m_list.iterator();

    while (i.hasNext() && (res == null))
    {
      ButtonPanelItem item = (ButtonPanelItem)i.next();

      if (item.getContainer() == null)
    {
        continue;
    }

      if (!(item.getContainer() instanceof JButton))
    {
        continue;
    }

      Action action = ((JButton)item.getContainer()).getAction();

      if (action == null)
    {
        continue;
    }

      Object value = action.getValue(actionKey);

      if ((value != null) && value.equals(actionValue))
    {
        res = (JButton)item.getContainer();
    }
    }

    return res;
  }

  public JButton getButton(Class buttonClass)
  {
      if (!JButton.class.isAssignableFrom(buttonClass))
    {
        return null;
    }

      Iterator i = m_list.iterator();

      while (i.hasNext())
      {
          ButtonPanelItem item = (ButtonPanelItem)i.next();

          if ((item.getContainer() instanceof JButton) &&
              (item.getContainer().getClass().equals(buttonClass)))
        {
            return (JButton)item.getContainer();
        }
      }

      return null;
  }

  protected void updatePartitionSpecs()
  {
    PartitionLayout layout = (PartitionLayout)getLayout();
    int[]           specs  = new int[m_list.size()];

    for (int i = 0; i < m_list.size(); i++)
    {
      ButtonPanelItem item = (ButtonPanelItem)m_list.get(i);
      String          ref  = item.getName();

      if ((ref != null) && ref.equals(REF_REMAINDER))
    {
        specs[i] = PartitionLayout.REMAINDER;
    }
    else
    {
        specs[i] = PartitionLayout.PREFERRED;
    }
    }

    layout.setPartitionSpecs(specs);
  }

  class ButtonPanelItem
  {
    protected String    name;
    protected Container c;

    public ButtonPanelItem(String name, Container c)
    {
      this.name = name;
      this.c    = c;
    }

    public String getName()
    {
      return name;
    }

    public Container getContainer()
    {
      return c;
    }
  }

  class JRemainderPanel extends JPanel
  {
  }

  //---------------------------------------------------------------------------

  public static void main(String[] arg)
  {
    JButtonPanel panel = new JButtonPanel(true);

    panel.addButton("Hello");
    panel.addButton("Good-bye");
    panel.addSeparator();
    panel.addButton("test");
    panel.add(new JLabel("This is a little label!"));
    panel.addButton("The End");
    panel.addRemainder();
    panel.addButton("Fini");

    JFrame frame = new JFrame("Button Panel Test");

    frame.addWindowListener(new WindowAdapter()
    {
      @Override
    public void windowClosing(WindowEvent evt)
      {
        System.exit(0);
      }
    });

    frame.getContentPane().add(panel, BorderLayout.CENTER);
    frame.pack();
    frame.setVisible(true);
  }

}

