/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.util;

import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.ImageIcon;
import javax.swing.JFrame;

import com.sonicsw.ma.gui.MgmtConsole;

public abstract class JMAFrame extends JFrame implements WindowListener
{
    private boolean m_initialized = false;
    private String  m_name;
    private static final int DEF_WIDTH = 800;
    private static final int DEF_HEIGHT = 600;

    public JMAFrame(String name)
    {
        super();
        prepareJFrame(name);
    }
    
    private void prepareJFrame(String name) {
        
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);

        addWindowListener(this);

        m_name = name;

        if ((m_name == null) || (m_name.trim().length() == 0))
        {
            setTitle(ResourceManager.getString(getClass(),"JMADialog.unknownTitle"));
        }
        else{
    		String title = ResourceManager.getApplicationPropertyString("application.title");
    		setTitle( (title != null) ? title : 
				ResourceManager.getString( getClass(), "frame." + m_name + ".title"));
        }
    }

	protected abstract void maInitialize();
    protected abstract void maCleanup();

    public String getTitleKey()
    {
        return m_name;
    }

    public Object getId()
    {
        return null;
    }

    @Override
    public void setVisible(boolean newState)
    {
        if (!m_initialized)
        {
            maInitialize();

            if (!SizeHelper.restoreWindowSize(this))
            {
                pack();

                // set default size...
                setSize(DEF_WIDTH, DEF_HEIGHT);
            }

            if (!SizeHelper.restoreWindowPosition(this))
            {
                // Center window with respect to the screen.
                Dimension screenSize = getToolkit().getScreenSize();
                Dimension windowSize = getSize();

                int x = (screenSize.width  - windowSize.width) / 2;
                int y = (screenSize.height - windowSize.height) / 2;

                setLocation(x,y);
            }
            m_initialized = true;
        }
        super.setVisible(newState);
    }

    protected boolean canClose()
    {
        return true;
    }

    public void setImageIcon(ImageIcon icon)
    {
        if (icon != null)
        {
            setIconImage(icon.getImage());
        }
    }

    //-------------------------------------------------------------------------
    //
    // WindowListener implementation
    //
    //-------------------------------------------------------------------------

    @Override
    public void windowActivated(WindowEvent evt)
    {
    }

    @Override
    public void windowClosed(WindowEvent evt)
    {
        JWaitCursor wc = new JWaitCursor(this);

        if (m_initialized)
        {
            SizeHelper.saveWindowSize(this);
            SizeHelper.saveWindowPosition(this);
        }

        try
        {
            maCleanup();
        }
        catch (Exception e)
        {
            MgmtConsole.displayMessage(MgmtConsole.MESSAGE_ERROR, "Error while closing the dialog.",
                e, true);
        }
        finally
        {
            wc.release();
        }

        System.exit(0);
    }

    @Override
    public void windowClosing(WindowEvent evt)
    {
        if (canClose())
        {
            dispose();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent evt)
    {
    }

    @Override
    public void windowDeiconified(WindowEvent evt)
    {
    }

    @Override
    public void windowIconified(WindowEvent evt)
    {
    }

    @Override
    public void windowOpened(WindowEvent evt)
    {
    }
}
