/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.util;

import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.util.ArrayList;

import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.WorkspaceWindow;

public abstract class JMAInternalFrame extends    JInternalFrame
                                       implements InternalFrameListener
{
    private ArrayList        m_dependList    = null;
    private JMAInternalFrame m_dependFrame   = null;
    private Rectangle        m_restoreBounds = null;
    private boolean          m_initialized   = false;
    private boolean          m_isInit        = false;  // See addNotify method below...
    private String           m_name;


    public JMAInternalFrame(String name) throws IllegalArgumentException
    {
        super(null, true, true, true, true);
        prepareJMAInternalFrame(name);
    }
    
    private void prepareJMAInternalFrame(String name) {
        
        setDefaultCloseOperation(JInternalFrame.DO_NOTHING_ON_CLOSE);

        addInternalFrameListener(this);

        m_name = name;

        if ((m_name == null) || (m_name.trim().length() == 0))
        {
            super.setTitle(ResourceManager.getString(getClass(),"JMADialog.unknownTitle"));
        }
        else
        {
            super.setTitle(ResourceManager.getString(getClass(), "iframe." + m_name + ".title"));
        }
    }

    protected abstract void maInitialize();
    protected abstract void maCleanup();

    public String getTitleKey()
    {
        return m_name;
    }

    public Object getId()
    {
        return null;
    }

    @Override
    public void setMaximum(boolean b) throws PropertyVetoException
    {
        if (isMaximum == b)
        {
            return;
        }

        if(b)
        {
            m_restoreBounds = getBounds();
        }

        Boolean oldValue = isMaximum ? Boolean.TRUE : Boolean.FALSE;
        Boolean newValue = b ? Boolean.TRUE : Boolean.FALSE;
        fireVetoableChange(IS_MAXIMUM_PROPERTY, oldValue, newValue);
        isMaximum = b;
        firePropertyChange(IS_MAXIMUM_PROPERTY, oldValue, newValue);
    }

    public Rectangle getRestoreBounds()
    {
        if(m_restoreBounds == null)
        {
            return this.getNormalBounds();
        }

        return m_restoreBounds;
    }

    @Override
    public void setVisible(boolean newState)
    {
        if (!m_initialized && newState)
        {
            maInitialize();

            JMADesktopPane desktop = MgmtConsole.getMgmtConsole().getDesktopPane();

            boolean handled = SizeHelper.restoreWindowSize(this);

            handled = SizeHelper.restoreWindowPosition(this) && handled;

            if(handled)
            {
                // we have resized the window based on persisted sizes. However
                // we still want to maximize the new window based on the state of
                // the current window.
                JInternalFrame selected = desktop.getSelectedFrame();
                if(selected != null)
                {
                    try { 
                        setMaximum(selected.isMaximum()); 
                    } catch(Exception e) {
                        MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
                    }
                }
            }
            else
            {
                // check if the current window is maximized - if it is then
                // we want to maximize the new window
                JInternalFrame selected = desktop.getSelectedFrame();
                int count = desktop.getAllFrames().length;

                if((count == 1) || (selected != null && selected.isMaximum()))
                {
                    // cascade it first to get the correct non-maximized size
                    // and then maximize the window
                    desktop.cascade(this);
                    try { 
                        setMaximum(true); 
                    } catch(Exception e) {
                        MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.}
                    }
                }
                else
                {
                    // cascade window
                    desktop.cascade(this);
                }
            }
            m_initialized = true;
        }
        super.setVisible(newState);
    }

    protected boolean canClose()
    {
        return true;
    }

    @Override
    public void dispose()
    {
        dispose(true);
    }

    public void dispose(boolean canClose)
    {
        if (!canClose || (canClose && canClose()))
        {
            super.dispose();
        }
    }

    public void addDependantFrame(JMAInternalFrame frame)
    {
        // Can only make 'frame' dependant on this frame if it isn't already
        // dependant on a frame.
        //
        if (!frame.isDependant())
        {
            frame.setDependeeFrame(this);

            if ((m_dependList == null) || !m_dependList.contains(frame))
            {
                if (m_dependList == null)
                {
                    m_dependList = new ArrayList();
                }

                m_dependList.add(frame);
            }
        }
    }

    public void removeDependantFrame(JMAInternalFrame frame)
    {
        frame.setDependeeFrame(null);

        if (m_dependList != null)
        {
            m_dependList.remove(frame);

            if (m_dependList.isEmpty())
            {
                m_dependList = null;
            }
        }
    }

    public boolean isDependant()
    {
        return (m_dependFrame != null);
    }

    public void setDependeeFrame(JMAInternalFrame frame)
    {
        m_dependFrame = frame;
    }

    public JMAInternalFrame getDependeeFrame()
    {
        return m_dependFrame;
    }

    //-------------------------------------------------------------------------
    //
    // InternalFrameListener implementation
    //
    //-------------------------------------------------------------------------

    @Override
    public void internalFrameOpened(InternalFrameEvent evt)
    {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent evt)
    {
        dispose();
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent evt)
    {
        if (m_initialized)
        {
            SizeHelper.saveWindowSize(this);
            SizeHelper.saveWindowPosition(this);
        }

        JWaitCursor wc = new JWaitCursor(this);

        try
        {
            maCleanup();

            if (getDependeeFrame() != null)
            {
                removeDependantFrame(getDependeeFrame());
            }

            while (m_dependList != null && !m_dependList.isEmpty())
            {
                JMAInternalFrame aFrame = (JMAInternalFrame)m_dependList.remove(0);

                try
                {
                    aFrame.dispose(false);
                }
                catch (Exception e)
                {
                    MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
                }
            }

            m_dependList = null;
        }
        catch (Exception e)
        {
            MgmtConsole.displayMessage(MgmtConsole.MESSAGE_ERROR, "Failure closing internal frame - " + e.toString(), e, true);
        }
        finally
        {
            wc.release();
        }
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent evt)
    {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent evt)
    {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent evt)
    {
        MgmtConsole console = MgmtConsole.getMgmtConsole();

        if (this instanceof WorkspaceWindow)
        {
            ((WorkspaceWindow)this).stateChanged(null); // ChangeEvent not used.
        }
        else
        {
            console.getToolBar().clearActions();
        }
        return;
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent evt)
    {
    }
}
