/*
 * Created on Feb 24, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.sonicsw.ma.gui.util;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;

import javax.jms.JMSException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

import modelobjects.layout.PartitionLayout;

import com.sonicsw.ma.gui.IApplication;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.ModelListTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.JRowTableButtonPanel.JAddButton;

import progress.message.jclient.DestinationFactory;
import progress.message.jclient.MultiTopic;
import progress.message.jclient.Topic;

/**
 * @author jpace
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class JMultiTopicHelperPanel extends JPanel
{
	protected boolean					m_bIsReadOnly = false;
    protected JRowTable 				m_topicTable;
    protected JTextField				m_txTopicName;
    protected SmartRowTableButtonPanel	m_btnPanel = null;
    protected JMADialog					m_parent;
    
    private JTextField 					m_txQualifierName = null;
	private JComboBox 					m_cbQualifier = null;
    private MultiTopic					m_mt = null;
    private int							m_nType = JMultiTopicHelperDialog.TYPE_ALL;
    
    private static final int			QUAL_NONE = 0;
    private static final int			QUAL_GROUP_NAME = 1;
    private static final int			QUAL_ROUTING_NODE = 2;
    
	public JMultiTopicHelperPanel(JMADialog parent, int nType)
	{
        this(parent, false, null, nType);
    }

	public JMultiTopicHelperPanel(JMADialog parent, boolean bSetReadOnly, MultiTopic mt, int nType)
	{
        super(new BorderLayout(JPartitionPanel.DEFAULT_GAP_SIZE,
                               JPartitionPanel.DEFAULT_GAP_SIZE));

        setBorder();
        
        m_parent = parent;
        m_bIsReadOnly = bSetReadOnly;
        
        if (mt == null)
        {
        	try
			{
            	mt = DestinationFactory.createMultiTopic();
			}
        	catch (JMSException jmse)
			{
                MgmtConsole.displayMessage(parent, MgmtConsole.MESSAGE_ERROR, "Could not create MultiTopic.",
                		jmse, true);
			}
        }
        
        m_mt = mt;
        m_nType = nType;
        initializeUI();
    }

	private void setBorder() {
	    setBorder(BorderFactory.createEmptyBorder(JPartitionPanel.DEFAULT_TB_EDGE_GAP,
                                        JPartitionPanel.DEFAULT_LR_EDGE_GAP,
                                        JPartitionPanel.DEFAULT_TB_EDGE_GAP,
                                        JPartitionPanel.DEFAULT_LR_EDGE_GAP));
	}
	
	private void initializeUI() {
        initUI();
	}
	
    public MultiTopic getResult()
    {
    	return m_mt;
    }
    
    protected final void initUI()
    {
        add(createQualifierPanel(), BorderLayout.NORTH);
        
        JPartitionPanel topicBuilderPanel = new JPartitionPanel(false,"p,r",
        		ResourceManager.getString(getClass(),"dialog.JMultiTopicHelperDialog.Topics"));
        PartitionLayout layout = (PartitionLayout)topicBuilderPanel.getLayout();
        
        JPanel panel = new JPanel(new BorderLayout(JPartitionPanel.DEFAULT_GAP_SIZE,
                JPartitionPanel.DEFAULT_GAP_SIZE));
        
        panel.add(makeMultiTopicTable(), BorderLayout.CENTER);
        
        if (m_bIsReadOnly == false)
        {
        	panel.add(m_btnPanel = makeMultiTopicButtons(), BorderLayout.EAST);
        }
        
        topicBuilderPanel.addRow(panel);
        add(topicBuilderPanel, BorderLayout.CENTER);

        initTopicTable();
        enableFields();
    }

    protected JPartitionPanel createQualifierPanel()
    {
        JPartitionPanel qualifierPanel = new JPartitionPanel(false,"p,r",ResourceManager.getString(getClass(),
        	"dialog.JMultiTopicHelperDialog.Qualifier"));
        PartitionLayout layout = (PartitionLayout)qualifierPanel.getLayout();

        if (m_nType == JMultiTopicHelperDialog.TYPE_ALL)
        {
	        m_cbQualifier = new JComboBox(new Object[] {
	        		ResourceManager.getString(getClass(), "dialog.JMultiTopicHelperDialog.None"),
	        		ResourceManager.getString(getClass(), "dialog.JMultiTopicHelperDialog.GroupName"),
					ResourceManager.getString(getClass(), "dialog.JMultiTopicHelperDialog.RoutingNode")} );
        }
        else if (m_nType == JMultiTopicHelperDialog.TYPE_RECEIVE)
        {
	        m_cbQualifier = new JComboBox(new Object[] {
	        		ResourceManager.getString(getClass(), "dialog.JMultiTopicHelperDialog.None"),
	        		ResourceManager.getString(getClass(), "dialog.JMultiTopicHelperDialog.GroupName")} );
        }
        else
        {
	        m_cbQualifier = new JComboBox(new Object[] {
	        		ResourceManager.getString(getClass(), "dialog.JMultiTopicHelperDialog.None"),
					ResourceManager.getString(getClass(), "dialog.JMultiTopicHelperDialog.RoutingNode")} );
        }
        
        qualifierPanel.addRow(ResourceManager.getString(getClass(),
            "dialog.JMultiTopicHelperDialog.QualifierType"), m_cbQualifier);

        int nIndex = QUAL_NONE;
        if (((progress.message.jimpl.MultiTopic)m_mt).hasGroup())
        {
            nIndex = QUAL_GROUP_NAME;
        }
        else if (((progress.message.jimpl.MultiTopic)m_mt).hasRouting())
        {
            nIndex = QUAL_ROUTING_NODE;
        }
        
        setSelectedQualifier(nIndex);
        m_cbQualifier.addActionListener(new ActionListener()
		{
            @Override
            public void actionPerformed(ActionEvent evt)
            {
            	enableFields();
            }
		});        
        
        m_txQualifierName = new JTextField();
        m_txQualifierName.addCaretListener(new CaretListener()
        {
            @Override
            public void caretUpdate(CaretEvent e) { enableFields(); }
            public void insertUpdate(DocumentEvent e) { }
            public void removeUpdate(DocumentEvent e) { }
            public void changedUpdate(DocumentEvent e) { }

        });
        qualifierPanel.addRow(ResourceManager.getString(getClass(),
            "dialog.JMultiTopicHelperDialog.QualifierName"),m_txQualifierName);
        
        m_txQualifierName.setText(((progress.message.jimpl.MultiTopic)m_mt).hasGroup() ?
        		((progress.message.jimpl.MultiTopic)m_mt).getGroupName() :
        			((progress.message.jimpl.MultiTopic)m_mt).getRouting());
        
        return qualifierPanel;
    }
    
    protected int getSelectedQualifier()
    {
    	int nSel = QUAL_NONE;
    	
    	Object obj = m_cbQualifier.getSelectedItem();
    	
        if (((String)obj).compareTo(ResourceManager.getString(getClass(), "dialog.JMultiTopicHelperDialog.GroupName")) == 0)
        {
        	nSel = QUAL_GROUP_NAME;
        }
        else if (((String)obj).compareTo(ResourceManager.getString(getClass(), "dialog.JMultiTopicHelperDialog.RoutingNode")) == 0)
        {
        	nSel = QUAL_ROUTING_NODE;
        }
    	
        return nSel;
    }
    
    protected void setSelectedQualifier(int nSel)
    {
        if (nSel == QUAL_GROUP_NAME)
        {
            m_cbQualifier.setSelectedItem(ResourceManager.getString(getClass(), "dialog.JMultiTopicHelperDialog.GroupName"));    	
        }
        else if (nSel == QUAL_ROUTING_NODE)
        {
            m_cbQualifier.setSelectedItem(ResourceManager.getString(getClass(), "dialog.JMultiTopicHelperDialog.RoutingNode"));    	
        }
        else
        {
        	m_cbQualifier.setSelectedItem(ResourceManager.getString(getClass(), "dialog.JMultiTopicHelperDialog.None"));
        }
    }
    
    protected void enableFields()
    {
        int nIndex = getSelectedQualifier();

        if (m_topicTable != null)
        {
	        m_txQualifierName.setEnabled(!m_bIsReadOnly && nIndex != QUAL_NONE && m_topicTable.getRowCount() == 0);
			m_cbQualifier.setEnabled(!m_bIsReadOnly && m_topicTable.getRowCount() == 0);
        }
    
    	boolean bEnable = !m_bIsReadOnly && (nIndex == QUAL_NONE || (nIndex != QUAL_NONE && m_txQualifierName.getText().length() > 0));
    	
    	enableFields(bEnable);
    }
    
    protected void enableFields(boolean bEnable)
    {
        if (m_btnPanel != null)
        {
    		m_btnPanel.setEnabled(bEnable);  	
        	m_txTopicName.setEnabled(bEnable);
        	m_topicTable.setEnabled(bEnable);
        }
    }
    
    private void initTopicTable()
    {
        IModelTableModel model = (IModelTableModel) m_topicTable.getModel();
    	
    	try
		{
	    	Iterator iter = m_mt.iterator();
	    	
	    	while (iter.hasNext())
	    	{
                progress.message.jimpl.Topic topic = (progress.message.jimpl.Topic)iter.next();

                if (m_topicTable.getRowCount() == 0)
                {
	                if (topic.hasGroup())
	                {
	                    setSelectedQualifier(QUAL_GROUP_NAME);
	                	m_txQualifierName.setText(topic.getGroupName());
	                }
	                else if (topic.hasRouting())
	                {
	                    setSelectedQualifier(QUAL_ROUTING_NODE);
	                	m_txQualifierName.setText(topic.getRouting());
	                }
                }

                model.insertRow(topic, m_topicTable.getRowCount());
	    	}
		}
        catch (JMSException jmse)
        {
            MgmtConsole.displayMessage(m_parent, MgmtConsole.MESSAGE_ERROR, "Could not iterate MultiTopic.",
                    jmse, true);
        }
    }

    private SmartRowTableButtonPanel makeMultiTopicButtons()
    {
    	SmartRowTableButtonPanel panel = new SmartRowTableButtonPanel(m_topicTable);

        panel.setAddAction(new AddAction());
        //TODO need to implement Edit action when support is added to Topic.
        //panel.setEditAction(new EditAction());
        panel.setRemoveAction(new RemoveAction(panel.getRemoveAction()));
        panel.addRemainder();
        
        JButton btnAdd = panel.getButton(JAddButton.class);
        btnAdd.setDefaultCapable(true);

        panel.updateState(null);

        return panel;
    }

    private JComponent makeMultiTopicTable()
    {
    	JPanel panel = new JPanel();
    	panel.setLayout(new BorderLayout(0,0));
    	
    	TopicRowTableColumn[] COLUMNS = { new TopicRowTableColumn(0, ResourceManager.getString(getClass(),
        		"panel.topicbuilder.topic.names"), 100), };

        COLUMNS[0].setSortable(false);

        m_topicTable = new JRowTable(COLUMNS, getClass().getName());

        ExtendedJScrollPane scroller = new ExtendedJScrollPane(m_topicTable);
        panel.add(scroller, BorderLayout.CENTER);
        scroller.setPreferredSize(new java.awt.Dimension(300,200));
        
        JLabel labelNewTopic = new JLabel(ResourceManager.getString(getClass(), "panel.topicbuilder.topic.new.label"));
        labelNewTopic.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, JPartitionPanel.DEFAULT_LR_EDGE_GAP));
        
        if (m_bIsReadOnly == false)
        {
	        JPanel panelNewTopic = new JPanel();
	        panelNewTopic.setLayout(new BorderLayout(0,0));
	        panelNewTopic.add(labelNewTopic, BorderLayout.WEST);
	        panelNewTopic.add(m_txTopicName = new JTextField(), BorderLayout.CENTER);
	        panelNewTopic.setBorder(BorderFactory.createEmptyBorder(0, 0, JPartitionPanel.DEFAULT_TB_EDGE_GAP, 0));
	        
	        panel.add(panelNewTopic, BorderLayout.NORTH);
        }
        
        return panel;
    }

    //-------------------------------------------------------------------------
    // Inner Classes
    class TopicRowTableColumn extends RowTableColumn
	{
        public TopicRowTableColumn(int modelIndex, String headerLabel)
		{
        	super(modelIndex, headerLabel);
		}

        public TopicRowTableColumn(int modelIndex, String headerLabel, int width)
		{
        	super(modelIndex, headerLabel, width);
		}

		public TopicRowTableColumn(int modelIndex, String headerLabel, int width, TableCellRenderer cellRenderer)
		{
			super(modelIndex, headerLabel, width, cellRenderer);
		}
		
		public TopicRowTableColumn(int modelIndex, String headerLabel, int width,
				TableCellRenderer cellRenderer, TableCellEditor cellEditor)
		{
			super(modelIndex, headerLabel, width, cellRenderer, cellEditor);
		}
		
        @Override
        public Object getColumnValue(Object rowModel)
        {
            Object objTopicName = ((progress.message.jimpl.Topic)rowModel).getTopicNameOnly();
            
            return objTopicName;
        }
	}
    
    class SmartRowTableButtonPanel extends JRowTableButtonPanel
	{
        public SmartRowTableButtonPanel(JRowTable table)
        {
        	super(table, true);
        }

        public SmartRowTableButtonPanel(JRowTable table, boolean autoEdit)
        {
        	super(table, autoEdit, JPartitionPanel.DEFAULT_GAP_SIZE, 0, 0);
        }

        public SmartRowTableButtonPanel(JRowTable table, int gapSize, int tbEdgeGap, int lrEdgeGap)
        {
        	super(table, true, gapSize, tbEdgeGap, lrEdgeGap);
        }

        public SmartRowTableButtonPanel(JRowTable table, boolean autoEdit,
                                    int gapSize, int tbEdgeGap, int lrEdgeGap)
        {
            super(table, autoEdit, gapSize, tbEdgeGap, lrEdgeGap);
        }
		
		/* (non-Javadoc)
		 * @see java.awt.Component#setEnabled(boolean)
		 */
		@Override
        public void setEnabled(boolean bEnable)
		{
			super.setEnabled(bEnable);
			
			getTable().setEnabled(bEnable);

			if (bEnable == true)
			{
				updateState(getTable().getSelectionModel());				
			}
			else
			{
	            if (getAddAction() != null)
                {
                    getAddAction().setEnabled(false);
                }

	            if (getEditAction() != null)
                {
                    getEditAction().setEnabled(false);
                }

	            if (getRemoveAction() != null)
                {
                    getRemoveAction().setEnabled(false);
                }
			}
		}
		
		/* (non-Javadoc)
		 * @see com.sonicsw.ma.gui.util.JRowTableButtonPanel#updateState(javax.swing.ListSelectionModel)
		 */
		@Override
        protected void updateState(ListSelectionModel selModel)
		{
			if (isEnabled())
			{
				super.updateState(selModel);
			}
		}
	}
    
    class AddAction extends BasicGuiAction
    {
        public AddAction()
        {
            super("editable_component.addOnly");
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            String strNewTopic = m_txTopicName.getText();
            
            if (strNewTopic.length() > 0)
            {
	            IModelTableModel model = (IModelTableModel) m_topicTable.getModel();
	
	            if ((model.findCell(0, 0, strNewTopic) == -1))
	            {
	                try
					{
	                	javax.jms.Topic t = DestinationFactory.createTopic(strNewTopic);
                        
                        if (t instanceof MultiTopic)
                        {
                            MgmtConsole.displayMessage(m_parent, MgmtConsole.MESSAGE_WARNING, "Could not add MultiTopic. Multitopic-based topics are not supported in the Topic Builder.",
                                null, true);

                            return;
                        }
                        
		            	if (getSelectedQualifier() == QUAL_GROUP_NAME && !((progress.message.jimpl.Topic)t).hasGroup())
		            	{
		            		// group name
		            		((progress.message.jimpl.Topic)t).initGroupName(m_txQualifierName.getText());
		            	}
		            	else if (getSelectedQualifier() == QUAL_ROUTING_NODE && !((progress.message.jimpl.Topic)t).hasRouting())
		            	{
		            		// routing node
		            		((progress.message.jimpl.Topic)t).initRouting(m_txQualifierName.getText());
		            	}
		            	String s = t.getTopicName();
	                	m_mt.add(t);
		                
		                model.insertRow(t, m_topicTable.getRowCount());
		
		                // Force selection on to newly added row...
		                int found = model.findCell(0, 0, strNewTopic);
		
		                if (found != -1)
                        {
                            m_topicTable.getSelectionModel().setSelectionInterval(found, found);
                        }
					}
	                catch (JMSException jmse)
					{
	                    MgmtConsole.displayMessage(m_parent, MgmtConsole.MESSAGE_WARNING, "Could not add Topic to MultiTopic. Topic name failed validation.",
	                    		jmse, true);

	                    return;
					}
	            }
	            
	            m_txTopicName.setText("");
            }
            
            enableFields();
        }
    }

    class EditAction extends BasicGuiAction
    {
        public EditAction()
        {
            super("editable_component.edit");
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
        	try
			{
	            IModelTableModel model = (IModelTableModel) m_topicTable.getModel();
	            int sel = m_topicTable.getSelectedRow();
	            
	            Topic topic = (Topic) model.getRowModel(sel);
	            String strTopicOldName = topic.getName();
	            EditTopicNameDialog dialog = new EditTopicNameDialog(m_parent, strTopicOldName);
	
	            dialog.setVisible(true);
	
	            if (dialog.getCloseCommand() == JMADialog.CLOSE_OK)
	            {
	                String strTopicNewName = dialog.getResult();
	
	                if ((strTopicNewName.length() > 0) && !strTopicOldName.equals(strTopicNewName))
	                {
	                    // Check if we have match that isn't the current selection,
	                    // to prevent duplicates
	                    int match = model.findCell(0, 0, strTopicNewName);
	
	                    if ((match != -1) && (match != sel))
                        {
                            Toolkit.getDefaultToolkit().beep();
                        }
                        else
	                    {
	                    	((progress.message.jimpl.Topic)topic).setTopicName(strTopicNewName);
	                        model.getContents().set(sel, strTopicNewName);
	                        ((ModelListTableModel) model).fireTableRowsUpdated(sel, sel);
	                    }
	                }
	            }
			}
        	catch (JMSException jmse)
			{
                MgmtConsole.displayMessage(m_parent, MgmtConsole.MESSAGE_WARNING, "Could not edit topic name.",
                		jmse, true);
			}
        }
        
        class EditTopicNameDialog extends JMADialog
	    {
	        JTextField m_txTopicName = new JTextField(32);
	        Action m_okAction;
	        String m_strTopicName;

	        public EditTopicNameDialog(JMADialog parent, String strTopicName)
	        {
	            super(parent, "JTopicNameEditorDialog");
	            setResizableProperty();
	            m_okAction = createOKAction();
	            m_strTopicName = strTopicName;
	        }

	        private void setResizableProperty() {
	            setResizable(false);
	        }
	        
	        private OKAction createOKAction() {
	            return new OKAction(this.getDefaultOKAction());
	        }
	        
	        @Override
            public void maInitialize()
	        {
	            getContentPane().add(makeMainPanel());
	            m_txTopicName.setText(m_strTopicName);
	        }

	        @Override
            public void maCleanup()
	        {
	        }

	        private JPanel makeMainPanel()
	        {
	            JPanel panel = new JPanel(new GridBagLayout());
	            GridBagConstraints gbc = new GridBagConstraints();

	            Helper.setConstraints(gbc, 0, 0, 1, 1, 0.0, 0.0,
	                                  GridBagConstraints.WEST,
	                                  GridBagConstraints.NONE);
	            panel.add(new JLabel("Topic: "), gbc);

	            Helper.setConstraints(gbc, 1, 0, 1, 1, 0.0, 0.0,
	                                  GridBagConstraints.WEST,
	                                  GridBagConstraints.HORIZONTAL);
	            panel.add(m_txTopicName, gbc);

	            panel.setBorder(BorderFactory.createEmptyBorder(JPartitionPanel.DEFAULT_TB_EDGE_GAP,
                        JPartitionPanel.DEFAULT_LR_EDGE_GAP,
                        JPartitionPanel.DEFAULT_TB_EDGE_GAP,
                        JPartitionPanel.DEFAULT_LR_EDGE_GAP));
	            
	            return panel;
	        }

	        public String getResult()
	        {
	            return m_txTopicName.getText();
	        }

	        @Override
            public Action[] getButtonActions()
	        {
	            ArrayList list = new ArrayList();

	            list.add(m_okAction);
	            list.add(getDefaultCancelAction());

	            return (Action[]) list.toArray(new Action[list.size()]);
	        }

	        /*
	         * Inner classes of EditTopicNameDialog
	         */
	        class OKAction extends BasicGuiAction
	        {
	            public OKAction(Action target)
	            {
	                super("dialog.ok", target);
	            }

	            @Override
                public void actionPerformed(ActionEvent evt)
	            {
	                if (getResult().length() == 0)
	                {
	                    MgmtConsole.getMgmtConsole().notifyMessage(IApplication.
	                        MESSAGE_ERROR, "Topic name can't be empty", true);
	                    
	                    return;
	                }

	                super.actionPerformed(evt);
	            }
	        }
	    }
    }

    class RemoveAction extends BasicGuiAction
    {
        public RemoveAction(Action target)
        {
			super("editable_component.remove", target);
        }
        
        @Override
        public void actionPerformed(ActionEvent evt)
        {
        	try
			{
	            IModelTableModel model = (IModelTableModel) m_topicTable.getModel();
	            int sel = m_topicTable.getSelectedRow();
	            
	            Topic topic = (Topic) model.getRowModel(sel);
	            
                int match = model.findCell(0, 0, ((progress.message.jimpl.Topic)topic).getTopicNameOnly());
            	
                if (match != -1)
                {
                	model.delete(topic);
                    ((ModelListTableModel) model).fireTableRowsDeleted(match, match);
    	            m_mt.remove(topic);
                    
                    // Maintain selection if possible
                    m_topicTable.getSelectionModel().clearSelection();
                }
			}
	    	catch (JMSException jmse)
			{
	            MgmtConsole.displayMessage(m_parent, MgmtConsole.MESSAGE_WARNING, "Could not remove topic.",
	            		jmse, true);
			}
	    	
            enableFields();
        }
    }
}
