/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.util;

import java.awt.Component;
import java.awt.Insets;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

import modelobjects.layout.PartitionLayout;

public class JPartitionPanel extends JPanel
{
    private static final boolean DEFAULT_VERTICAL_LAYOUT = false;
    private static final String  DEFAULT_ENCODED_LAYOUT  = "p,r,p";

    public static final int DEFAULT_GAP_SIZE    = 5;
    public static final int DEFAULT_TB_EDGE_GAP = 5;
    public static final int DEFAULT_LR_EDGE_GAP = 5;
    public static final int BORDER_SIZE = new JSplitPane().getWidth();
    public static final Insets BORDER_INSETS = new Insets (BORDER_SIZE, BORDER_SIZE, BORDER_SIZE, BORDER_SIZE);

    public JPartitionPanel()
    {
        this(null);
    }

    public JPartitionPanel(String borderTitle)
    {
        this(DEFAULT_VERTICAL_LAYOUT, DEFAULT_ENCODED_LAYOUT, borderTitle);
    }

    public JPartitionPanel(boolean verticalLayout, String borderTitle)
    {
        this(verticalLayout, DEFAULT_ENCODED_LAYOUT, borderTitle);
    }

    public JPartitionPanel(boolean verticalLayout,
                           String  encodedLayout,
                           String  borderTitle)
    {
        this(verticalLayout, encodedLayout, borderTitle, DEFAULT_GAP_SIZE,
             DEFAULT_TB_EDGE_GAP, DEFAULT_LR_EDGE_GAP);
    }

    public JPartitionPanel(boolean verticalLayout,
                           String  encodedLayout,
                           String  borderTitle,
                           int     gapSize)
    {
        this(verticalLayout, encodedLayout, borderTitle, gapSize, gapSize, gapSize);
    }

    public JPartitionPanel(boolean verticalLayout,
                           String  encodedLayout,
                           String  borderTitle,
                           int     sepGap,
                           int     tbEdgeGap,
                           int     lrEdgeGap)
    {
        super(new PartitionLayout(verticalLayout,
                                  encodedLayout,
                                  sepGap,
                                  tbEdgeGap,
                                  lrEdgeGap,
                                  null));

        if (borderTitle != null)
        {
            setBorder(borderTitle);
        }
    }

    private void setBorder(String  borderTitle) {
        setBorder(BorderFactory.createTitledBorder(borderTitle));
    }
    
    public JComponent addRow(JComponent field)
    {
        return addRow((JLabel)null, new JComponent[] { field })[0];
    }

    public JComponent addRow(JLabel label, JComponent field)
    {
        return addRow(label, new JComponent[] { field })[0];
    }

    public JComponent addRow(String labelName, JComponent field)
    {
        return addRow(labelName, field, null);
    }

    public JComponent addRow(String labelName, JComponent field, String unitName)
    {
        return addRow(labelName, new JComponent[] { field, new JLabel(unitName) })[0];
    }

    public JComponent addRow(JLabel label, JComponent field, String unitName)
    {
        return addRow(label, new JComponent[] { field, new JLabel(unitName) })[0];
    }

    public JComponent[] addRow(String labelName, JComponent[] field)
    {
        return addRow(new JLabel((labelName != null) ? (labelName + ":") : ""), field);
    }

    public JComponent[] addRow(JLabel label, JComponent[] field)
    {
        JComponent[] list = new JComponent[field.length + 1];

        list[0] = (label != null) ? label : new JLabel();

        for (int i = 1; i < list.length; i++)
        {
            list[i] = field[i-1];
        }

        return addRow(list);
    }

    public JComponent[] addRow(JComponent[] field)
    {
        if (!(getLayout() instanceof PartitionLayout))
        {
            return new JComponent[0];
        }

        boolean hasSP = containsScrollPane(field);
        int numCompInRow = ((PartitionLayout)getLayout()).getNumPartitions();
        int i = 0;

        while (numCompInRow > 0)
        {
            if ((field != null) && (i < field.length))
            {
                if (hasSP && (!(field[i] instanceof JScrollPane)))
                {
                    add(internalWrap(field[i++]));
                }
                else
                {
                    add(field[i++]);
                }
            }
            else
            {
                add(new JPanel());
            }

            numCompInRow--;
        }

        return field;
    }

    private boolean containsScrollPane(JComponent[] c)
    {
      for (int i = 0; i < c.length; i++)
    {
        if (c[i] instanceof JScrollPane)
        {
            return true;
        }
    }

      return false;
    }

    private JPanel internalWrap(JComponent c)
    {
        JPanel panel = new JPanel(new PartitionLayout(true, "p", 0, 0, 0, null));

        panel.add(c);

        return panel;
    }

    public Border getPreferredBorder()
    {
        Border outer = BorderFactory.createEmptyBorder(JPartitionPanel.DEFAULT_TB_EDGE_GAP,
                                                       JPartitionPanel.DEFAULT_LR_EDGE_GAP,
                                                       JPartitionPanel.DEFAULT_TB_EDGE_GAP,
                                                       JPartitionPanel.DEFAULT_LR_EDGE_GAP);

        Border inner = BorderFactory.createBevelBorder(BevelBorder.RAISED,
                                                       getBackground(),
                                                       null,
                                                       getBackground(),
                                                       null);

        return BorderFactory.createCompoundBorder(outer, inner);
    }

    //-------------------------------------------------------------------------
    //
    // Static helper methods
    //
    //-------------------------------------------------------------------------

    public static final JPartitionPanel wrap(JComponent component)
    {
        JPartitionPanel panel = new JPartitionPanel(true, "p", null);

        panel.add(component);

        return panel;
    }

    public static final JPartitionPanel wrap(JPanel component)
    {
        return wrap((JComponent)component);
    }

    public static final JPartitionPanel merge(String      partition,
                                              boolean     vertical,
                                              Component[] component)
    {
        JPartitionPanel panel = new JPartitionPanel(vertical, partition, null);

        for (int i = 0; i < component.length; i++)
        {
            if (component[i] == null)
            {
                panel.add(new JPanel());
            }
            else
            {
                panel.add(component[i]);
            }
        }

        return panel;
    }


    public static final JPartitionPanel merge(String      partition,
                                              boolean     vertical,
                                              int         sepGap,
                                              int         tbEdgeGap,
                                              int         lrEdgeGap,
                                              Component[] component)
    {
        JPartitionPanel panel = new JPartitionPanel(vertical, partition, null, sepGap, tbEdgeGap, lrEdgeGap);

        for (int i = 0; i < component.length; i++)
        {
            if (component[i] == null)
            {
                panel.add(new JPanel());
            }
            else
            {
                panel.add(component[i]);
            }
        }

        return panel;
    }

    //-------------------------------------------------------------------------

}
