package com.sonicsw.ma.gui.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;

import com.sonicsw.ma.gui.MgmtConsole;


public class JPasswordButtonViewAspectAdapter extends ViewAspectAdapter
    implements ActionListener
{
    public static final String RES_ACTION = "password.default";

    private Object  m_password;
    private JButton m_viewComponent;
    private boolean m_hashed;
    private boolean m_useDefault;

    private final BasicAction m_defAction = new PasswordAction();

    public JPasswordButtonViewAspectAdapter(ModelAspectId      modelAspectId,
                                            JButton            viewComponent,
                                            EditRule           editRule,
                                            ViewValueConverter viewValueConverter,
                                            ModelEditMediator  modelEditMediator,
                                            boolean            hashed)
    {
        this(modelAspectId, viewComponent, editRule, viewValueConverter,
             modelEditMediator, hashed, true);
    }

    public JPasswordButtonViewAspectAdapter(ModelAspectId      modelAspectId,
                                            JButton            viewComponent,
                                            EditRule           editRule,
                                            ViewValueConverter viewValueConverter,
                                            ModelEditMediator  modelEditMediator,
                                            boolean            hashed,
                                            boolean            useDefaultPassword)
    {
        super(modelAspectId, editRule, viewValueConverter, modelEditMediator);

        setViewComponent(viewComponent);

        m_useDefault = useDefaultPassword;
        m_hashed     = hashed;
    }

    private void setViewComponent(JButton viewComponent)
    {
        if (m_viewComponent != null)
        {
            m_viewComponent.removeActionListener(this);
        }

        m_viewComponent = viewComponent;

        // If no action has been set then set the default action...
        //
        if (m_viewComponent.getAction() == null)
        {
            m_viewComponent.setAction(getDefaultAction());
        }
        else
        {
            Action old = m_viewComponent.getAction();

            // If we have a targetable action then set the target action to be the
            // default password action...
            //
            if (old instanceof BasicAction)
            {
                ((BasicAction)old).setTargetAction(getDefaultAction());
            }
        }

        m_viewComponent.addActionListener(this);
    }

    @Override
    public Component getViewComponent()
    {
        return m_viewComponent;
    }

    public boolean isHashed()
    {
        return m_hashed;
    }

    public BasicAction getDefaultAction()
    {
        return m_defAction;
    }

    @Override
    public boolean isEditable()
    {
        return m_viewComponent.isEnabled();
    }

    @Override
    public void setEditable(boolean editable)
    {
        if (editable != m_viewComponent.isEnabled())
        {
            m_viewComponent.setEnabled(editable);
        }
    }

    @Override
    public Object getViewAspectValue()
    {
        Object res = null;

        if (m_password != null)
        {
            res = m_password;
        }
        else
        if (m_useDefault == true)
        {
            res = getDefaultPassword();
        }

        return res;
    }

    @Override
    public String getViewAspectStringValue()
    {
        return getViewAspectValue().toString();
    }

    @Override
    protected void setViewAspectValue(Object viewAspectValue)
        throws IllegalArgumentException
    {
        if (viewAspectValue == null)
        {
            ;
        }
        else
        if (isHashed())
        {
            if (viewAspectValue instanceof byte[])
            {
                m_password = viewAspectValue;
            }
        }
        else if (viewAspectValue instanceof String)
        {
            m_password = viewAspectValue;
        }
        else
        {
            throw new IllegalArgumentException(this.getModelAspectId().getName() +  " : invalid password format - expecting byte[], got " + viewAspectValue.getClass().getName());
        }
    }

    public void setPasswordValue(Object value)
        throws IllegalArgumentException
    {
        setViewAspectValue(value);

        fireChangeEvent();
    }

    @Override
    protected void setViewAspectStringValue(String viewStringValue)
        throws IllegalArgumentException
    {
        if (isHashed())
        {
            throw new IllegalArgumentException(getModelAspectId().getName() +  " : can't take hashed password as a string - insecure!");
        }

        m_password = viewStringValue;
    }

    private Object getDefaultPassword()
    {
        Object res = null;

        if (isHashed())
        {
            try
            {
                res = PasswordHash.doSHA(new String(""));
            }
            catch (Exception e)
            {
                MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR, "Error getting password.", e, true);
            }
        }

        return res;
    }

    //-------------------------------------------------------------------------
    //
    // ActionListener implementation
    //
    //-------------------------------------------------------------------------

    @Override
    public void actionPerformed(ActionEvent event)
    {
    }

    //-------------------------------------------------------------------------

    class PasswordAction extends BasicGuiAction
    {
        public PasswordAction()
        {
            super(RES_ACTION);
        }

        @Override
        public void actionPerformed(ActionEvent event)
        {
            JPasswordDialog dialog = null;

            JMADialog pDialog = (JMADialog)SwingUtilities.getAncestorOfClass(JMADialog.class,
                getViewComponent());

            if (pDialog != null)
            {
                dialog = new JPasswordDialog(pDialog);
            }
            else
            {
                JMAFrame pFrame = (JMAFrame)SwingUtilities.getAncestorOfClass(JMADialog.class,
                    getViewComponent());

                if (pFrame != null)
                {
                    dialog = new JPasswordDialog(pFrame);
                }
            }

            if (dialog != null)
            {
                dialog.setVisible(true);

                if (dialog.getCloseCommand() == JMADialog.CLOSE_OK)
                {
                    // Save off the password.
                    m_password = isHashed() ? (Object)dialog.getHashedPassword() :
                        (Object)dialog.getPassword();

                    fireChangeEvent();
                }
                dialog.dispose();
            }            
        }
    }
}
