/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.util;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.Document;

import modelobjects.layout.PartitionLayout;

public class JPathField extends JComponent
{
  protected JTextField  m_field = null;
  protected JPathButton m_btn   = null;

  public JPathField()
  {
    this(null, null, 0);
  }

  public JPathField(String text)
  {
    this(text, 0);
  }

  public JPathField(int columns)
  {
    this(null, columns);
  }

  public JPathField(String text, int columns)
  {
    this(null, text, columns);
  }

  public JPathField(Document doc, String text, int columns)
  {
      prepareJPathField(doc, text, columns);
  }
  
  private void prepareJPathField(Document doc, String text, int columns) {
      
    setLayout(new PartitionLayout(false, "r,p", 2, 0, 0, "JPathField"));

    m_field = new JTextField(doc, text, columns);
    m_btn   = new JPathButton();

    m_btn.setMargin(new Insets(1, 1, 1, 1));

    add(m_field);
    add(m_btn);
  }

  @Override
public boolean isEnabled()
  {
    if (m_field != null)
    {
        return m_field.isEnabled();
    }

    if (m_btn != null)
    {
        return m_btn.isEnabled();
    }

    return false;
  }

  @Override
public void setEnabled(boolean b)
  {
    if (m_field != null)
    {
        m_field.setEnabled(b);
    }

    if (m_btn != null)
    {
        m_btn.setEnabled(b);
    }
  }

  public void setButtonActionCommand(String btnAction)
  {
    if (m_btn != null)
    {
        m_btn.setActionCommand(btnAction);
    }
  }

  public String getButtonActionCommand()
  {
    return (m_btn != null) ? m_btn.getActionCommand() : null;
  }

  public void setButtonAction(Action a)
  {
    if (m_btn != null)
    {
        m_btn.setAction(a);
    }
  }

  public void setTextAction(Action a)
  {
    if (m_field != null)
    {
        m_field.setAction(a);
    }
  }

  public Action getButtonAction()
  {
    return (m_btn != null) ? m_btn.getAction() : null;
  }

  public Action getTextAction()
  {
    return (m_field != null) ? m_field.getAction() : null;
  }

  public Document getDocument()
  {
    return (m_field != null) ? m_field.getDocument() : null;
  }

  public boolean isEditable()
  {
    return (m_field != null) ? m_field.isEditable() : false;
  }

  public void setEditable(boolean b)
  {
    if (m_field != null)
    {
        m_field.setEditable(b);
    }

    if (m_btn != null)
    {
        m_btn.setEnabled(b);
    }
  }

  public String getText()
  {
    return (m_field != null) ? m_field.getText() : null;
  }

  public void setText(String text)
  {
    if (m_field != null)
    {
        m_field.setText(text);
    }
  }

  public void addActionListener(ActionListener l)
  {
    if (m_field != null)
    {
        m_field.addActionListener(l);
    }

    if (m_btn != null)
    {
        m_btn.addActionListener(l);
    }
  }

  public void removeActionListener(ActionListener l)
  {
    if (m_field != null)
    {
        m_field.removeActionListener(l);
    }

    if (m_btn != null)
    {
        m_btn.removeActionListener(l);
    }
  }

  @Override
public void setBackground(Color color)
  {
    if (m_field != null)
    {
        m_field.setBackground(color);
    }
  }

  @Override
public Color getBackground()
  {
    return (m_field != null) ? m_field.getBackground() : super.getBackground();
  }

  //--------------------------------------------------------------------------

  class JPathButton extends JBrowseButton
  {
    public JPathButton()
    {
      super();
    }

    /**
     * Override method in AbstractButton so that we can change the
     * source of the ActionEvent to be the JPathField itself and not
     * the internal JButton.
     */
    @Override
    protected void fireActionPerformed(ActionEvent event)
    {
      Object[]    listeners = listenerList.getListenerList();
      ActionEvent e         = null;
      // Process the listeners last to first, notifying
      // those that are interested in this event
      for (int i = listeners.length-2; i>=0; i-=2)
      {
        if (listeners[i] == ActionListener.class)
        {
          // Lazily create the event:
          if (e == null)
          {
            String actionCommand = event.getActionCommand();

            if (actionCommand == null)
            {
                actionCommand = getActionCommand();
            }

            e = new ActionEvent(JPathField.this,
                                ActionEvent.ACTION_PERFORMED,
                                actionCommand,
                                event.getWhen(),
                                event.getModifiers());
          }

          ((ActionListener)listeners[i+1]).actionPerformed(e);
        }
      }
    }
  }
}

