package com.sonicsw.ma.gui.util;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;

import com.sonicsw.mf.common.license.ProductDecoder;

public class JProductDecoderDialog extends JMADialog
{
    private static final String RES_EVAL_MODE     = "eval_mode";
    private static final String FEATURE_EVAL_MODE = "Evaluation Mode";
    
    JRowTable  m_table;
    JCheckBox  m_evalMode = new JCheckBox();

    ProductDecoder m_decoder = null;
    Boolean m_newEvalMode = null;
    Boolean m_oldEval = null;

    public JProductDecoderDialog(JMADialog      parent,
                                 ProductDecoder decoder,
                                 Boolean        oldEval)
    {
        super(parent, "product-decoder");

        m_decoder = decoder;
        m_oldEval = oldEval;
    }

    @Override
    public void maInitialize()
    {
        initUI();
        initForm();
    }

    @Override
    protected void maCleanup()
    {
        if (m_table != null)
        {
            m_table.cleanup();
        }
    }

    protected void initUI()
    {
        try
        {
            getContentPane().add(makeMainPanel());
        }
        catch (Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR, "Unable to initialize the form", e, true);
        }
    }

    protected void initForm()
    {
        m_evalMode.addItemListener(new ItemListener()
        {
            @Override
            public void itemStateChanged(ItemEvent evt)
            {
                m_newEvalMode = new Boolean(m_evalMode.isSelected());
            }
        });


        // First set the default evaluation mode from that encoded in the
        // Control Number...
        //
        m_evalMode.setSelected(getFeatureEvaluationMode());

        // If we already have an eval mode set in the configuration then use
        // that...
        //
        if (m_oldEval != null)
        {
            m_evalMode.setSelected(m_oldEval.booleanValue());
        }
    }

    protected JPanel makeMainPanel()
    {
        JPartitionPanel panel = new JPartitionPanel(true, "r,p", null, 0, 0, 0);

        panel.add(makeFeaturesPanel());
        panel.add(makeProductInformationPanel());

        return panel;
    }

    private void insertRow(String name, Object value)
    {
        if ((value != null) && (value instanceof String) &&
            ((String)value).startsWith("-1"))
        {
            value = "Unlimited";
        }

        int rowCount = m_table.getRowCount();
        ((IModelTableModel)m_table.getModel()).insertRow(new ProductEntry(name, value), rowCount);
    }

    protected JPanel makeFeaturesPanel()
    {
        JPartitionPanel panel = new JPartitionPanel(false, "r", "Features");

        TableColumn[] COLUMNS = new TableColumn[2];
        COLUMNS[0] = new ProductNameTableColumn(0, "Feature");
        COLUMNS[1] = new ProductValueTableColumn(1, "Value");

        m_table = new JRowTable(COLUMNS, getClass().getName());
        m_table.setPreferredScrollableViewportSize(new Dimension(COLUMNS[0].getPreferredWidth() +
                                                                 COLUMNS[1].getPreferredWidth(),
                                                                 12 * m_table.getRowHeight()));

        insertRow("Control Number", m_decoder.getControlNumber());
        insertRow("Version",        m_decoder.getVersion());
        insertRow("Product Name",   m_decoder.getProductName());
        insertRow("Product Number", Integer.toString(m_decoder.getProductCode()));
        insertRow("Serial Number",  Integer.toString(m_decoder.getSerialNumber()));
        String[] features = m_decoder.getFeatureList();
        for (int i = 0; i < features.length; i++)
        {
            if (!features[i].equals(FEATURE_EVAL_MODE))
            {
                insertRow(features[i], m_decoder.getFeatureValue(features[i]));
            }
        }

        ExtendedJScrollPane sp = new ExtendedJScrollPane(m_table);

        panel.add(sp);

        return panel;
    }

    private boolean getFeatureEvaluationMode()
    {
        String value = m_decoder.getFeatureValue(FEATURE_EVAL_MODE);
        
        return (value == null) || (value.length() == 0) || value.equalsIgnoreCase("true");
    }
    
    protected JPanel makeProductInformationPanel()
    {
        JPartitionPanel panel = new JPartitionPanel("Control");

        panel.addRow(getResourceLabel(RES_EVAL_MODE),  m_evalMode);

        return panel;
    }

    private String getResourceLabel(String name)
    {
        return ResourceManager.getString(getClass(), "dialog." + getTitleKey() + "." + name + ".label");
    }
    
    private JTextField initJTextField(JTextField field)
    {
        field.setBorder(null);
        field.setBackground(UIManager.getColor("Label.background"));
        field.setEditable(false);

        return field;
    }

    public Boolean isEvalMode()
    {
/* This logic is flawed - if the decoder IS in evaluation mode and the user
   has enabled evaluation mode at the checkbox then we return FALSE here????
   That doesn't make sense.

        if ((m_newEvalMode != null) &&
            (m_newEvalMode.booleanValue() == m_decoder.isEvaluationMode()))
            return Boolean.FALSE;
*/

        return m_newEvalMode;
    }

    //-------------------------------------------------------------------------
    //
    // Inner classes
    //
    //-------------------------------------------------------------------------

    class ProductEntry
    {
        private String m_feature;
        private Object m_value;


        public ProductEntry(String feature, Object value)
        {
            setProperties(feature, value);
        }

        private void setProperties(String feature, Object value) {
            setFeature(feature);
            setValue(value);
        }
        
        public void setFeature(String feature)
        {
            m_feature = feature;
        }

        public String getFeature()
        {
            return m_feature;
        }

        public void setValue(Object value)
        {
            m_value = value;
        }

        public Object getValue()
        {
            return m_value;
        }
    }

    class ProductNameTableColumn extends RowTableColumn
    {
        public ProductNameTableColumn(int modelIndex, String title)
        {
            super(modelIndex, title, 60);
        }

        @Override
        public Object getColumnValue(Object rowModel)
        {
            return ((ProductEntry)rowModel).getFeature();
        }
    }

    class ProductValueTableColumn extends RowTableColumn
    {
        public ProductValueTableColumn(int modelIndex, String title)
        {
            super(modelIndex, title, 40);
        }

        @Override
        public Object getColumnValue(Object rowModel)
        {
            return (String)((ProductEntry)rowModel).getValue();
        }
    }

    //-------------------------------------------------------------------------

}
