/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

import com.sonicsw.ma.gui.MgmtConsole;

public class JProgressDialog extends JDialog
{
    private SwingWorker  m_worker;
    private JButton      m_btnCancel;
    private JProgressBar m_bar = new JProgressBar();

    public JProgressDialog(JMADialog parent,
                           String    title,
                           boolean   modal)
    {
        super(parent, title, modal);
    }

    public JProgressDialog(JMAFrame parent,
                           String   title,
                           boolean  modal)
    {
        super(parent, title, modal);
        prepareJProgressDialog();
    }
    
    private void prepareJProgressDialog() {
        
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        setResizable(false);

        addWindowListener(new WindowAdapter()
        {
            @Override
            public void windowClosing(WindowEvent ect)
            {
                doCancel();
            }
        });

        m_bar.setIndeterminate(true);

        m_btnCancel = new JButton("Cancel");
        m_btnCancel.setDefaultCapable(true);
        m_btnCancel.addActionListener(new ActionListener()
        {
            @Override
            public void actionPerformed(ActionEvent evt)
            {
                doCancel();
            }
        });

        JComponent      btnPanel = JPartitionPanel.merge("r,p,r", false, new Component[] { new JPanel(), m_btnCancel, new JPanel() });
        JPartitionPanel bottom   = JPartitionPanel.merge("p,p", true, new Component[] { m_bar, btnPanel });
        getContentPane().add(bottom, BorderLayout.SOUTH);

        pack();

        setLocation(getCenteredLocation());
    }

    public JProgressBar getProgressBar()
    {
        return m_bar;
    }

    public JButton getCancelButton()
    {
        return m_btnCancel;
    }

    public void setWorker(SwingWorker worker)
    {
        m_worker = worker;
    }

    public void setContent(JComponent content)
    {
        getContentPane().add(JPartitionPanel.wrap(content), BorderLayout.CENTER);

        pack();
    }

    @Override
    public void setVisible(boolean state)
    {
        if (state)
        {
            m_worker.start();
        }

        super.setVisible(state);
    }

    private void doCancel()
    {
        try
        {
            if (m_worker != null)
            {
                m_worker.interrupt();
            }

            setVisible(false);

            dispose();
        }
        catch (Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
                                  "Error performing cancel operation.", e, true);
        }
    }

    private Point getCenteredLocation()
    {
        Point     pLoc  = getParent().getLocation();
        Dimension pSize = getParent().getSize();
        Dimension cSize = getPreferredSize();

        return new Point (pLoc.x + ((pSize.width - cSize.width) / 2),
                          pLoc.y + ((pSize.height - cSize.height) / 2));
    }
}
