/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.util;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public final class JTimeField
    extends JPanel
    implements ActionListener, FocusListener, MouseListener
{
    JTextField m_hour;
    JLabel     m_sep;
    JTextField m_min;

    public JTimeField()
    {
        this(null);
    }

    public JTimeField(String text)
    {
        super(new GridBagLayout());

        m_hour = new JTextField(new TimeUnitDocument(2), null, 2);
        m_min  = new JTextField(new TimeUnitDocument(2), null, 2);
        m_sep  = new JLabel(":");

        m_hour.setBorder(null);
        m_min.setBorder(null);
        m_sep.setOpaque(false);

        setProperties(text);

        addGridBagConstraints();
    }
    
    private void addGridBagConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.anchor = GridBagConstraints.WEST;

        JPanel pad = new JPanel();
        pad.setOpaque(false);

        add(m_hour, gbc);
        gbc.gridx = 1;
        add(m_sep, gbc);
        gbc.gridx = 2;
        add(m_min, gbc);
        gbc.gridx = 3;
        gbc.weightx = 1.0;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        add(pad, gbc);
        
    }
    
    private final void setProperties(String text) {
        setBorder(UIManager.getBorder("TextField.border"));
        setBackground(UIManager.getColor("TextField.background"));
        setText(text);
    }

    @Override
    public boolean isEnabled()
    {
        return super.isEnabled();
    }

    @Override
    public void setEnabled(boolean b)
    {
        if (b == isEnabled())
        {
            return;
        }

        super.setEnabled(b);

        m_hour.setEnabled(b);
        m_min.setEnabled(b);
    }

    public void setText(String text)
    {
        int splitPos = text.indexOf(":");

        if (splitPos > 0)
        {
            m_hour.setText(text.substring(0, splitPos).trim());
            m_min.setText(text.substring(splitPos + 1).trim());
        }
    }

    public String getText()
    {
        return padString(m_hour.getText().trim()) + ":" +
               padString(m_min.getText().trim());
    }

    public String getHourText()
    {
        return padString(m_hour.getText().trim());
    }

    public String getMinuteText()
    {
        return padString(m_min.getText().trim());
    }

    public void addDocumentListener(DocumentListener l)
    {
        m_hour.getDocument().addDocumentListener(l);
        m_min.getDocument().addDocumentListener(l);
    }

    public void removeDocumentListener(DocumentListener l)
    {
        m_hour.getDocument().removeDocumentListener(l);
        m_min.getDocument().removeDocumentListener(l);
    }

    //-------------------------------------------------------------------------
    //
    // MouseListener implementation
    //
    //-------------------------------------------------------------------------

    @Override
    public void mouseClicked(MouseEvent evt)
    {
    }

    @Override
    public void mouseEntered(MouseEvent evt)
    {
    }

    @Override
    public void mouseExited(MouseEvent evt)
    {
    }

    @Override
    public void mousePressed(MouseEvent evt)
    {
    }

    @Override
    public void mouseReleased(MouseEvent evt)
    {
    }

    //-------------------------------------------------------------------------
    //
    // ActionListener implementation
    //
    //-------------------------------------------------------------------------

    @Override
    public void actionPerformed(ActionEvent evt)
    {
    }

    //-------------------------------------------------------------------------
    //
    // FocusListener implementation
    //
    //-------------------------------------------------------------------------

    @Override
    public void focusGained(FocusEvent evt)
    {
    }

    @Override
    public void focusLost(FocusEvent evt)
    {
    }

    //-------------------------------------------------------------------------

    private String padString(String value)
    {
        if (value.length() == 0)
        {
            return "00";
        }

        if (value.length() == 1)
        {
            return "0" + value;
        }

        return value;
    }

    //-------------------------------------------------------------------------
    //
    // Inner classes
    //
    //-------------------------------------------------------------------------

    class TimeUnitDocument extends PlainDocument
    {
        private int m_columns;

        public TimeUnitDocument(int columns)
        {
            m_columns = columns;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a)
            throws BadLocationException
        {
            if (str == null)
            {
                return;
            }

            str = stripNonNumeric(str);

            int newLength = getLength() + str.length();

            if (getLength() == m_columns)
            {
                Toolkit.getDefaultToolkit().beep();
            }

            if (newLength > m_columns)
            {
                str = str.substring(0, m_columns - getLength());
            }

            super.insertString(offs, str, a);
        }

        protected String stripNonNumeric(String str)
        {
            StringBuffer sb = new StringBuffer();

            for (int i = 0; i < str.length(); i++)
            {
                if (Character.isDigit(str.charAt(i)))
                {
                    sb.append(str.charAt(i));
                }
            }

            return sb.toString();
        }
    }

}
