/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.util;

import java.awt.Component;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.ViewAspectAdapter;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;

public class JURLFieldViewAspectAdapter extends    ViewAspectAdapter
                                        implements DocumentListener,
                                                   UndoableEditListener
{
    private JURLField viewComponent;
    private boolean   fireUndoableTextEvents;


    public JURLFieldViewAspectAdapter(ModelAspectId modelAspectId,
                                      JURLField     viewComponent)
    {
        this(modelAspectId, viewComponent, false);
    }

    public JURLFieldViewAspectAdapter(ModelAspectId modelAspectId,
                                      JURLField     viewComponent,
                                      boolean       fireUndoableTextEvents)
    {
        super(modelAspectId);
        this.fireUndoableTextEvents = fireUndoableTextEvents;
        setViewComponent(viewComponent);
    }

    public JURLFieldViewAspectAdapter(ModelAspectId      modelAspectId,
                                      JURLField          viewComponent,
                                      EditRule           editRule,
                                      ViewValueConverter viewValueConverter,
                                      ModelEditMediator  modelEditMediator)
    {
        this(modelAspectId, viewComponent, editRule, viewValueConverter,
             modelEditMediator, false);
    }

    public JURLFieldViewAspectAdapter(ModelAspectId      modelAspectId,
                                      JURLField          viewComponent,
                                      EditRule           editRule,
                                      ViewValueConverter viewValueConverter,
                                      ModelEditMediator  modelEditMediator,
                                      boolean            fireUndoableTextEvents)
    {
        super(modelAspectId, editRule, viewValueConverter, modelEditMediator);

        this.fireUndoableTextEvents = fireUndoableTextEvents;
        setViewComponent(viewComponent);
    }

    private void setViewComponent(JURLField viewComponent)
    {
        this.viewComponent = viewComponent;

        viewComponent.getSchemeDocument().addDocumentListener(this);
        viewComponent.getHostDocument().addDocumentListener(this);
        viewComponent.getPortDocument().addDocumentListener(this);

        if (fireUndoableTextEvents)
        {
            viewComponent.getSchemeDocument().addUndoableEditListener(this);
            viewComponent.getHostDocument().addUndoableEditListener(this);
            viewComponent.getPortDocument().addUndoableEditListener(this);
        }
    }

    @Override
    public Component getViewComponent()
    {
        return viewComponent;
    }

    @Override
    public boolean isEditable()
    {
        return viewComponent.isEditable();
    }

    @Override
    public void setEditable(boolean editable)
    {
        if (editable != viewComponent.isEditable())
        {
            viewComponent.setEditable(editable);
        }
    }

    @Override
    public Object getViewAspectValue()
    {
        return viewComponent.getText();
    }

    @Override
    public String getViewAspectStringValue()
    {
        return viewComponent.getText();
    }

    @Override
    protected void setViewAspectValue(Object viewAspectValue)
        throws IllegalArgumentException
    {
        if (viewAspectValue == null)
        {
            viewComponent.setText("");
        }
        else if (viewAspectValue instanceof String)
        {
            viewComponent.setText((String)viewAspectValue);
        }
        else
        {
            throw(new IllegalArgumentException("value must be a String: " + getModelAspectId()));
        }
    }

    @Override
    protected void setViewAspectStringValue(String viewStringValue)
        throws IllegalArgumentException
    {
        if (viewStringValue == null)
        {
            viewComponent.setText("");
        }
        else
        {
            viewComponent.setText(viewStringValue);
        }
    }

    //-------------------------------------------------------------------------
    //
    //  DocumentListener implementation
    //
    //-------------------------------------------------------------------------

    @Override
    public void changedUpdate(DocumentEvent event)
    {
        fireChangeEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent event)
    {
        fireChangeEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent event)
    {
        fireChangeEvent();
    }

    //-------------------------------------------------------------------------
    //
    //  UndoableEditListener implementation
    //
    //-------------------------------------------------------------------------

    @Override
    public void undoableEditHappened(UndoableEditEvent edit)
    {
        if (fireUndoableTextEvents)
        {
            fireUndoableEditEvent(edit.getEdit());
        }
    }

    //-------------------------------------------------------------------------

}
