/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.util;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

import com.sonicsw.ma.gui.table.IContentPane;
import com.sonicsw.ma.gui.table.ITableContentPane;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IPlugin;

/**
 * PluginTreeMenuShower looks at mouse events to decide when it's time to show
 * a JPopupMenu, and then adjusts the position of the popup if it wasn't
 * completely on screen.
 */
public class PluginMenuShower extends CommonPopupMenuShower
{
    private static final int[] MENU_TYPE =
    {
        IPlugin.NEW_TYPE,
        IPlugin.PLUGIN_TYPE,
        IPlugin.EDIT_TYPE,
        IPlugin.SYSTEM_TYPE,
        IPlugin.VIEW_TYPE,
        IConfigPlugin.PERMISSIONS_TYPE,
        IPlugin.PROPERTIES_TYPE,
    };

    private IContentPane m_contentPane;


    public PluginMenuShower(JTree tree)
    {
        super(tree, new JPopupMenu());
    }

    public PluginMenuShower(ITableContentPane contentPane)
    {
        super(contentPane.getTable(), new JPopupMenu());

        m_contentPane = contentPane;
    }

    @Override
    protected List getMenuItems()
    {
        List list = null;

        if (m_contentPane != null)
        {
            list = new ArrayList();

            for (int i = 0; i < MENU_TYPE.length; i++)
            {
                JComponent[] items = null;

                items = m_contentPane.getMenuItems(MENU_TYPE[i]);

                addToList(list, items);
            }
        }
        else if (getTree() != null)
        {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)getTree().getSelectionPath().getLastPathComponent();

            if (node instanceof IPlugin)
            {
                list = getMenuItems((IPlugin)node);
            }
        }

        return list;
    }

    @Override
    protected List getParentMenuItems()
    {
        return getMenuItems(m_contentPane.getPlugin());
    }

    private List getMenuItems(IPlugin plugin)
    {
        ArrayList list = new ArrayList();

        for (int i = 0; i < MENU_TYPE.length; i++)
        {
            JComponent[] items = plugin.getMenuItems(MENU_TYPE[i]);

            addToList(list, items);
        }

        return list;
    }

    private void addToList(List list, JComponent[] subList)
    {
        if ((subList != null) && (subList.length > 0))
        {
            if (!list.isEmpty())
            {
                list.add(new JSeparator());
            }

            for (int i = 0; i < subList.length; i++)
            {
                list.add(subList[i]);
            }
        }
    }

}
