package com.sonicsw.ma.gui.util;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.ITableContentPane;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.IMonitorPlugin;
import com.sonicsw.ma.plugin.IPlugin;

import javax.swing.JTree;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import java.awt.event.MouseEvent;

public class PluginMouseClickListener extends PluginMenuShower
{

    public PluginMouseClickListener(JTree tree)
    {
        super(tree);
    }

    public PluginMouseClickListener(ITableContentPane contentPane)
    {
        super(contentPane);
    }

    @Override
    public void mouseClicked(MouseEvent evt)
    {
        super.mouseClicked(evt);
        if(evt.getSource() instanceof JTree)
        {
            JTree tempTree = (JTree) evt.getSource();
            final TreePath selectionPath = tempTree.getSelectionPath();
            if(selectionPath != null)
            {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode) selectionPath.getLastPathComponent();
                if (node != null && node instanceof AbstractGUIPlugin)
                {
                    IPlugin plugin = (IPlugin) node;
                    plugin.getPluginContext().getWorkspace().updateSelection();
                }
            }
        }
        else if(evt.getSource() instanceof JRowTable)
        {
            JTable tempTable = (JTable) evt.getSource();
            final TableModel model = tempTable.getModel();
            if( model instanceof IModelTableModel)
            {
                final Object rowModel = ((IModelTableModel) model).getRowModel(tempTable.getSelectedRow());
                if(rowModel instanceof AbstractGUIPlugin)
                {
                    IPlugin plugin = (IPlugin) rowModel;
                    plugin.getPluginContext().getWorkspace().updateSelection();
                }
                if(rowModel instanceof IMonitorPlugin )
                {
                    IMonitorPlugin plugin = (IMonitorPlugin) rowModel;
                    MgmtConsole.getMgmtConsole().getSelectedWorkspaceWindow().fireGUIMonitorPluginChanged(plugin);
                }
            }
        }
    }
}

