package com.sonicsw.ma.gui.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

import modelobjects.framework.EditRule;
import modelobjects.framework.ModelEditMediator;
import modelobjects.framework.UndoableModelAspectEdit;
import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.util.ObjectCopier;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.JRowTableAspectAdapter;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.util.ConfigHelper;


public class PrimitiveListTableAspectAdapter extends    JRowTableAspectAdapter
                                             implements ObjectCopier
{

    public PrimitiveListTableAspectAdapter(ModelAspectId     modelAspectId,
                                           JRowTable         table,
                                           EditRule          editRule,
                                           ModelEditMediator modelEditMediator)
    {
        super(modelAspectId, table, null, editRule, modelEditMediator);

        rowModelCopier = this;
  }

  @Override
protected void setViewAspectValue(Object viewAspectValue)
    throws IllegalArgumentException
    {
        if (viewAspectValue == null)
        {
            return;
        }

        if (!(viewAspectValue instanceof IAttributeList))
        {
            throw new IllegalArgumentException("The view aspect value must be of type IAttributeList!");
        }

        try
        {
            IAttributeList list      = (IAttributeList)((IAttributeList)viewAspectValue).clone();
            ArrayList     contents = new ArrayList(list.size());
            Iterator      i        = list.iterator();

            while (i.hasNext())
            {
                Object value = i.next();

                if (value != null)
                {
                    contents.add(new PrimitiveModel(value));
                }
            }
            super.setViewAspectValue(contents);
        }
        catch (Exception e)
        {
            MgmtConsole.displayMessage(MgmtConsole.MESSAGE_ERROR, e.toString(), e, true);
        }
    }

   // the following is provided so subclasses can access the method on JTableListAspectAdapter

    protected void setViewAspectValue(List value)
    {
        super.setViewAspectValue(value);
    }

    @Override
    public Object getViewAspectValue()
    {
        IAttributeList list = null;

        try
        {
            List     contents = ((IModelTableModel)table.getModel()).getContents();
            Iterator i        = contents.iterator();
            list = getParentModel();

            while (i.hasNext())
            {
                PrimitiveModel rowModel = (PrimitiveModel)i.next();
                list.addAttribute(rowModel.getValue());
            }
        }
        catch (ConfigServiceException e)
        {
            MgmtConsole.displayMessage(MgmtConsole.MESSAGE_ERROR, e.toString(), e, true);
        }

        return list;
    }

    @Override
    public Object copyObject(Object obj)
    {
        return obj;
    }

    public Object createRowModelInstance(Object value)
    {
        return new PrimitiveModel(value);
    }
    @Override
    public UndoableModelAspectEdit makeUndoableModelAspectEdit(ModelObjectAdapter modelObjectAdapter)
        throws ViewValueConversionException
    {
        return new UndoableModelAspectEdit("changed " + getModelAspectId(),
                                           modelObjectAdapter,
                                           getModelAspectId(),
                                           getOldModelAspectValue(),
                                           getModelAspectValue());
    }

    private IAttributeList getParentModel()
    {
        IConfigPath     path   = ConfigFactory.createConfigPath(getModelAspectId().getName());
        ConfigBeanModel model  = (ConfigBeanModel)getModelEditMediator().getModel().getModelObject();
        IAttributeMap   map    = model.getData();
        IAttributeList  parent = (IAttributeList)map.getAttribute(path);

        if (parent == null)
        {
            parent = (IAttributeList)ConfigHelper.createChild(map, path);
        }
        else
        {
            parent.clear();
        }

        return parent;
    }


    //-----------Inner classes--------------------------------

    //Wrapper around primitive objects//
    public class PrimitiveModel
    {
        protected Object m_value;

        public PrimitiveModel(Object value)
        {
            m_value = value;
        }

        public Object getValue()
        {
            return m_value;
        }

        @Override
        public boolean equals(Object value)
        {
            if (!(value instanceof PrimitiveModel))
            {
                return false;
            }

            return getValue().equals(((PrimitiveModel)value).getValue());
        }
        
        @Override
        public int hashCode() {
            return Objects.hashCode(getValue());
        }

    }

}