/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;

public class PropertyDescriptorHelper
{
  Class m_theClass;
  BeanInfo m_beanInfo;
  PropertyDescriptor[] m_descriptors;


  public PropertyDescriptorHelper(Class theClass)
      throws Exception
  {

    m_theClass = theClass;
    m_beanInfo = Introspector.getBeanInfo(m_theClass);
    m_descriptors = m_beanInfo.getPropertyDescriptors();
  }

  public PropertyDescriptor findPropertyDescriptor(String propName)
  {
    for(int i=0; i<m_descriptors.length; i++)
    {

      if(m_descriptors[i].getName().equals(propName))
    {
        return m_descriptors[i];
    }
    }

    return null;
  }

  public static final PropertyDescriptor find(Class theClass, String propName)
      throws Exception
  {
      return new PropertyDescriptorHelper(theClass).findPropertyDescriptor(propName.toLowerCase());
  }

}
