/*
 * Created on Apr 26, 2005
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.util;


import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;

import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.Query;

public class QueryConverter implements ViewValueConverter
{
    private IConfigServer m_server;
    private String        m_suffix = null;
    private String        m_type  = null;
    protected static String NONE    = "<None>"; 
    
    public QueryConverter(IConfigServer server, String type)
    {
        m_server = server;
        m_type = type;
    }
    

    public QueryConverter(IConfigServer server,String type, String suffix)
    {
        this(server, type);
        m_suffix = suffix;
    }

    @Override
    public Object viewValueToModel(Object viewValue)
    throws ViewValueConversionException
    {
        Object res = null;
        String DSname = null;

        if (viewValue instanceof String)
        {
            try
            {
                String value = (String)viewValue;
                
                if(value.equals(NONE))
                {
                    return null;
                }
                
                if (value.length() > 0)
                {
                    if (m_suffix == null)
                    {
                        DSname = ReferenceToStringConverter.convertFromView(value);
                    }
                    else
                    {
                        DSname = ReferenceToStringConverter.convertFromView(value, m_suffix);
                    }

                    res = m_server.loadConfigElement(DSname);
                }
            }
            catch (ConfigServiceException e)
            {
                throw new ViewValueConversionException("Could not load " + DSname + " (" + e.getMessage() + ")", e);
            }
            catch (NumberFormatException e)
            {
                throw new ViewValueConversionException("Not a com.sonicsw.mx.config.impl.Reference string", e);
            }
        }
        else
        {
            throw new ViewValueConversionException("Expected a string");
        }

        return res;
    }

    @Override
    public Object modelValueToView(Object modelValue)
        throws ViewValueConversionException
    {
        if (modelValue == null)
        {
            return NONE;
        }
        
        if (modelValue instanceof IConfigBean)
        {
            String name = ((IConfigBean)modelValue).getName();

            name = stripDefaulSuffix(name);
            return ReferenceToStringConverter.convertToView(name);
        }
        throw new ViewValueConversionException("Value not a com.sonicsw.mx.config.IConfigBean");
    }


    @Override
    public String[] getViewStringValues()
    {
        String[] names = null;

        try
        {
            Query query    = new Query().setFrom(new FromElementType(m_type));
            Set   elements = m_server.loadConfigElements(query);

            ArrayList list = new ArrayList(elements.size() + 1);
            list.add(NONE);

            Iterator  i        = elements.iterator();

            while(i.hasNext())
            {
                IConfigBean bean = (IConfigBean)i.next();
                String path = bean.getName();
                String name = null;

                if (path.endsWith(ConfigServerUtility.DEFAULT_SUFFIX) ||
                    path.endsWith(ConfigServerUtility.DOMAIN_DESCRIPTOR_SUFFIX)||
                    path.endsWith(ConfigServerUtility.POLICY_DESCRIPTOR_SUFFIX))
                {
                     int lastIndex = path.lastIndexOf('/');

                     path = path.substring(0, lastIndex);
                     name = ReferenceToStringConverter.convertToView(path);
                }
                else
                {
                    name = ReferenceToStringConverter.convertToView(path);
                }


                if(!(bean instanceof IConfigPrototype)) //ignore template
                {
                    list.add(name);
                }
            }

            names = (String[])list.toArray(new String[list.size()]);
        }
        catch (Exception e)
        {
            names = new String[]{ NONE };
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }

        return names;

    }

    @Override
    public boolean isViewValueToModelSupported()
    {
        return true;
    }

    @Override
    public Class getModelClass()
    {
        return IConfigBean.class;
    }

    @Override
    public Class getViewClass()
    {
        return String.class;
    }

    protected String stripDefaulSuffix(String name) {
        if (name.endsWith(ConfigServerUtility.DEFAULT_SUFFIX) ||
            name.endsWith(ConfigServerUtility.DOMAIN_DESCRIPTOR_SUFFIX) ||
            name.endsWith(ConfigServerUtility.POLICY_DESCRIPTOR_SUFFIX))
        {
            int lastIndex = name.lastIndexOf('/');
            name = name.substring(0, lastIndex);
        }
        return name;
    }

}
