/*
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.util;

import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;

import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.IdentityOnlyConfigBean;

/**
 * This class is a customizable ViewValueConverter for converting
 * mx.config.impl.Reference model values to Strings and back again.
 */
public class ReferenceToStringConverter implements ViewValueConverter
{
    private IConfigServer m_server;
    private String        m_suffix = null;

    public ReferenceToStringConverter(IConfigServer server)
    {
        m_server = server;
    }

    public ReferenceToStringConverter(IConfigServer server, String suffix)
    {
        this(server);
        m_suffix = suffix;
    }

    @Override
    public Object viewValueToModel(Object viewValue)
    throws ViewValueConversionException
    {
        Object res = null;
        String DSname = null;
        if(IdentityOnlyConfigBean.getUnIndentifiable()!=null && viewValue == IdentityOnlyConfigBean.getUnIndentifiable().toString()){
            return IdentityOnlyConfigBean.getUnIndentifiable();
        }

        if (viewValue instanceof String)
        {
            try
            {
                String value = (String)viewValue;

                if (value.length() > 0)
                {
                    if (m_suffix == null)
                    {
                        DSname = convertFromView(value);
                    }
                    else
                    {
                        DSname = convertFromView(value, m_suffix);
                    }

                    res = m_server.loadConfigElement(DSname);
                }
            }
            catch (ConfigServiceException e)
            {
                throw new ViewValueConversionException("Could not load " + DSname + " (" + e.getMessage() + ")", e);
            }
            catch (NumberFormatException e)
            {
                throw new ViewValueConversionException("Not a com.sonicsw.mx.config.impl.Reference string");
            }
        }
        else
        {
            throw new ViewValueConversionException("Expected a string");
        }

        return res;
    }

    @Override
    public Object modelValueToView(Object modelValue)
        throws ViewValueConversionException
    {
        if(modelValue == IdentityOnlyConfigBean.getUnIndentifiable())
        {
            return modelValue.toString();
        }
        if (modelValue instanceof IConfigBean)
        {
            String name = ((IConfigBean)modelValue).getName();

            if (name.endsWith(ConfigServerUtility.DEFAULT_SUFFIX) ||
                name.endsWith(ConfigServerUtility.DOMAIN_DESCRIPTOR_SUFFIX) ||
                name.endsWith(ConfigServerUtility.POLICY_DESCRIPTOR_SUFFIX))
            {
                int lastIndex = name.lastIndexOf('/');
                name = name.substring(0, lastIndex);
            }
            return convertToView(name);
        }
        throw new ViewValueConversionException("Value not a com.sonicsw.mx.config.IConfigBean");
    }

    public void setSuffix(String suffix)
    {
        m_suffix = suffix;
    }

    public static String convertToView(String value)
    {
        int    pathIndex = value.lastIndexOf('/');
        String path      = value.substring(0, pathIndex+1);

        if ((path.length() > 1) && path.endsWith("/"))
        {
            path = path.substring(0, path.length()-1);
        }

        return value.substring(pathIndex+1) + " ( " + path + " )";
    }

    public static String convertFromView(String value)
    {
        int    pathIndex = value.lastIndexOf('(');
        String path      = value.substring(pathIndex + 1, value.length() - 1).trim();
        StringBuffer sb = new StringBuffer(path);

        if (path.length() > 1)
        {
            sb.append('/');
        }

        sb.append(value.substring(0, pathIndex).trim());

        return sb.toString();

    }

    public static String convertFromView(String value, String suffix)
    {
        int    pathIndex = value.lastIndexOf('(');
        String path      = value.substring(pathIndex + 1, value.length() - 1).trim();
        String name      = value.substring(0, pathIndex).trim();

        StringBuffer sb  = new StringBuffer(path);

        if (path.length() > 1)
        {
            sb.append('/');
        }

        sb.append(name).append('/').append(suffix);

        return sb.toString();

    }

    @Override
    public String[] getViewStringValues()
    {
        return null;
    }

    @Override
    public boolean isViewValueToModelSupported()
    {
        return true;
    }

    @Override
    public Class getModelClass()
    {
        return IConfigBean.class;
    }

    @Override
    public Class getViewClass()
    {
        return String.class;
    }
}
