package com.sonicsw.ma.gui.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;

import javax.swing.Icon;
import javax.swing.ImageIcon;

/**
 * <p>Title: ResizeIcon</p>
 * <p>Description: Can resize a wrapped icon</p>
 * @author Huw Jones
 * @version 1.0
 */
public class ResizeIcon extends ImageIcon
{
    protected int  m_width;
    protected int  m_height;
    protected Icon m_icon;

    public ResizeIcon(Icon icon, int size)
    {
        this(icon, size, size);
    }
    
    public ResizeIcon(Icon icon, int width, int height)
    {
        super();
        
        m_icon = icon;
        m_width = width;
        m_height = height;
        
        setImage();
    }

    private void setImage() {
        
        Image tmp = createImage(m_icon, component);
        if (tmp != null)
        {
            setImage(tmp.getScaledInstance(m_width, m_height, Image.SCALE_SMOOTH));
        }
    }
    
    @Override
    public int getIconWidth()
    {
        return m_width;
    }

    @Override
    public int getIconHeight() 
    { 
        return m_height; 
    }
    
    @Override
    public void paintIcon(Component c, Graphics g, int nX, int nY)
    {
        super.paintIcon(c, g, nX, nY);
    }

    private Image createImage(Icon icon, Component c)
    {
        // Make sure there is something.
        if (icon == null)
        {
            return null;
        }

        // Render the icon into a bitmap image.
        BufferedImage imageCopy = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), BufferedImage.TYPE_INT_ARGB);
        Graphics g = imageCopy.getGraphics();
        icon.paintIcon(c, g, 0, 0);

        return imageCopy;
    }
}
